/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.events_on_client;

import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.gui.WeaponMasterScreen;
import com.minecraftserverzone.weaponmaster.setup.KeyHandler;
import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.server.HandActionSPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="weaponmaster_ydm", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientOnlyForgeSetup {
    public static int[] slotPositions = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
    public static int[] slotRotations = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
    public static int[] scale = new int[WeaponMasterMod.maxDisplaySlotNum];
    public static int xRot;
    public static int yRot;
    public static int fakexRot;
    public static int fakeyRot;
    public static int xPos;
    public static int yPos;
    public static String slotAttachment;
    public static String slotMover;
    public static int hideTick;
    public static String uniqueItemDisplay;
    public static int lastMainhandHit;
    public static int lastOffhandHit;
    public static String whitelist;
    public static String blacklist;

    @SubscribeEvent
    public static void clientInit(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        WeaponMasterMod.isMultiplayer = false;
    }

    public static void handActionPacket(Player player, boolean mainhand, int value) {
        if (WeaponMasterMod.isMultiplayer) {
            Networking.sendToServer(new HandActionSPacket(mainhand));
        }
    }

    @SubscribeEvent
    public static void clientInit(TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.m_91087_().f_91074_ && event.phase == TickEvent.Phase.END && event.player.m_183503_().m_5776_()) {
            if (event.player.m_6117_() && event.player.m_7655_() == InteractionHand.MAIN_HAND) {
                lastMainhandHit = 1;
            } else if (lastMainhandHit > 0 && lastMainhandHit <= hideTick) {
                ++lastMainhandHit;
            }
            if (event.player.m_6117_() && event.player.m_7655_() == InteractionHand.OFF_HAND) {
                lastOffhandHit = 1;
            } else if (lastOffhandHit > 0 && lastOffhandHit <= hideTick) {
                ++lastOffhandHit;
            }
        }
    }

    @SubscribeEvent
    public static void hit(InputEvent.MouseInputEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null && !Minecraft.m_91087_().m_91104_() && event.getAction() == 1 && event.getButton() == 0) {
            lastMainhandHit = 1;
            ClientOnlyForgeSetup.handActionPacket((Player)Minecraft.m_91087_().f_91074_, true, lastMainhandHit);
        }
    }

    @SubscribeEvent
    public static void keyPressed(InputEvent.KeyInputEvent event) {
        if (KeyHandler.OPEN_SCREEN.m_90857_()) {
            Minecraft.m_91087_().m_91152_((Screen)new WeaponMasterScreen());
        }
        if (Minecraft.m_91087_().f_91066_.f_92093_.m_90857_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onServerJoin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        int i;
        for (i = 0; i < WeaponMasterMod.maxDisplaySlotNum * 3; ++i) {
            ClientOnlyForgeSetup.slotPositions[i] = (Integer)ConfigHolder.COMMON.positions[i].get();
            ClientOnlyForgeSetup.slotRotations[i] = (Integer)ConfigHolder.COMMON.rotations[i].get();
        }
        for (i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
            ClientOnlyForgeSetup.scale[i] = (Integer)ConfigHolder.COMMON.scale[i].get();
        }
        slotAttachment = (String)ConfigHolder.COMMON.slot_attachment.get();
        slotMover = (String)ConfigHolder.COMMON.slotMover.get();
        hideTick = (Integer)ConfigHolder.COMMON.hideTick.get();
        uniqueItemDisplay = (String)ConfigHolder.COMMON.uniqueItemDisplay.get();
        whitelist = (String)ConfigHolder.COMMON.whitelist.get();
        blacklist = (String)ConfigHolder.COMMON.blacklist.get();
    }

    static {
        slotAttachment = "1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head,offhand-lleg,quiver-body";
        slotMover = "none,chest;z;+_none,chest,1;z;+_none,legs;x;-_none,legs;x;+_none,legs,3;x;-_none,legs,4;x;+_none,chest,legs,1;z;+_none,shield;z;+_none,legs,3,5;x;-_none;z;-_none;z;-_none,legs,4,6;x;+_none;z;+";
        lastMainhandHit = 1;
        lastOffhandHit = 1;
    }
}

