/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.impl.item.CopyTagShapedRecipe;
import fuzs.puzzleslib.impl.item.CopyTagShapelessRecipe;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public interface CopyTagRecipe {
    public static final String SHAPED_RECIPE_SERIALIZER_ID = "copy_tag_shaped_recipe";
    public static final String SHAPELESS_RECIPE_SERIALIZER_ID = "copy_tag_shapeless_recipe";

    public static RecipeSerializer<?> getModSerializer(String modId, String recipeSerializerId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)Registry.f_122865_.m_7745_(new ResourceLocation(modId, recipeSerializerId));
        Objects.requireNonNull(recipeSerializer, "%s serializer for %s is null".formatted(recipeSerializerId, modId));
        return recipeSerializer;
    }

    public static void registerSerializers(BiConsumer<String, Supplier<RecipeSerializer<?>>> registrar, Factory factory) {
        registrar.accept(SHAPED_RECIPE_SERIALIZER_ID, () -> factory.apply(new ShapedRecipe.Serializer(), CopyTagShapedRecipe::new));
        registrar.accept(SHAPELESS_RECIPE_SERIALIZER_ID, () -> factory.apply(new ShapelessRecipe.Serializer(), CopyTagShapelessRecipe::new));
    }

    public Ingredient getCopyTagSource();

    default public void tryCopyTagToResult(ItemStack result, CraftingContainer craftingContainer) {
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (!this.getCopyTagSource().test(itemStack) || !itemStack.m_41782_()) continue;
            result.m_41751_(itemStack.m_41783_().m_6426_());
            return;
        }
    }

    public static interface Factory {
        public <T extends CraftingRecipe, S extends CraftingRecipe & CopyTagRecipe> RecipeSerializer<S> apply(RecipeSerializer<T> var1, BiFunction<T, Ingredient, S> var2);
    }

    public static interface Serializer<T extends CraftingRecipe, S extends CraftingRecipe & CopyTagRecipe>
    extends RecipeSerializer<S> {
        public RecipeSerializer<T> serializer();

        public BiFunction<T, Ingredient, S> factory();

        default public S fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            CraftingRecipe recipe = (CraftingRecipe)this.serializer().m_6729_(recipeId, serializedRecipe);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"copy_from"));
            return (S)((CraftingRecipe)this.factory().apply(recipe, ingredient));
        }

        default public S fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CraftingRecipe recipe = (CraftingRecipe)this.serializer().m_8005_(recipeId, buffer);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return (S)((CraftingRecipe)this.factory().apply(recipe, ingredient));
        }

        default public void toNetwork(FriendlyByteBuf buffer, S recipe) {
            this.serializer().m_6178_(buffer, recipe);
            ((CopyTagRecipe)recipe).getCopyTagSource().m_43923_(buffer);
        }
    }
}

