/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core.context;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.item.v2.DisplayItemsOutput;
import fuzs.puzzleslib.impl.item.CreativeModeTabConfiguratorImpl;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record CreativeModeTabContextForgeImpl() implements CreativeModeTabContext
{
    @Override
    public void registerCreativeModeTab(CreativeModeTabConfigurator configurator) {
        final CreativeModeTabConfiguratorImpl impl = (CreativeModeTabConfiguratorImpl)configurator;
        CreativeModeTab tab = new CreativeModeTab(String.format("%s.%s", impl.getIdentifier().m_135827_(), impl.getIdentifier().m_135815_())){
            @Nullable
            private ItemStack[] icons;

            public ItemStack m_40787_() {
                if (impl.getIcons() != null) {
                    if (this.icons == null) {
                        this.icons = impl.getIcons().get();
                        Preconditions.checkPositionIndex((int)1, (int)this.icons.length, (String)"icons is empty");
                    }
                    int index = (int)(System.currentTimeMillis() / 2000L) % this.icons.length;
                    return this.icons[index];
                }
                return super.m_40787_();
            }

            public ItemStack m_6976_() {
                return impl.getIcon().get();
            }

            public void m_6151_(NonNullList<ItemStack> itemStacks) {
                impl.getDisplayItemsGenerator().accept(arg_0 -> itemStacks.add(arg_0));
            }

            public boolean hasSearchBar() {
                return impl.isHasSearchBar() || super.hasSearchBar();
            }
        };
        if (impl.isHasSearchBar()) {
            tab.setBackgroundImage(new ResourceLocation("textures/gui/container/creative_inventory/tab_item_search.png"));
        }
        impl.getDisplayItemsGenerator().accept(DisplayItemsOutput.setItemCategory(tab));
    }
}

