/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.impl.biome.BiomeLoadingContextForge;
import fuzs.puzzleslib.impl.biome.ClimateSettingsContextForge;
import fuzs.puzzleslib.impl.biome.GenerationSettingsContextForge;
import fuzs.puzzleslib.impl.biome.MobSpawnSettingsContextForge;
import fuzs.puzzleslib.impl.biome.SpecialEffectsContextForge;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public record BiomeModificationsContextForgeImpl(Set<ContentRegistrationFlags> availableFlags) implements BiomeModificationsContext
{
    private static final Map<BiomeLoadingPhase, EventPriority> BIOME_MODIFIER_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)new HashMap<BiomeLoadingPhase, EventPriority>(){
        {
            this.put(BiomeLoadingPhase.ADDITIONS, EventPriority.HIGH);
            this.put(BiomeLoadingPhase.REMOVALS, EventPriority.NORMAL);
            this.put(BiomeLoadingPhase.MODIFICATIONS, EventPriority.LOW);
            this.put(BiomeLoadingPhase.POST_PROCESSING, EventPriority.LOW);
        }
    });
    private static final Supplier<RegistryAccess> BUILT_IN_REGISTRY_ACCESS = Suppliers.memoize(BiomeModificationsContextForgeImpl::builtinCopy);

    @Override
    public void register(BiomeLoadingPhase phase, Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        Preconditions.checkArgument((boolean)this.availableFlags.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS), (Object)"biome modifications registration flag is missing");
        Objects.requireNonNull(phase, "phase is null");
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(modifier, "modifier is null");
        HashMultimap biomeEntries = HashMultimap.create();
        biomeEntries.put((Object)phase, (Object)new BiomeModification(selector, modifier));
        this.registerBiomeModifications((Multimap<BiomeLoadingPhase, BiomeModification>)biomeEntries);
    }

    private void registerBiomeModifications(Multimap<BiomeLoadingPhase, BiomeModification> biomeEntries) {
        for (Map.Entry entry : biomeEntries.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) continue;
            EventPriority priority = BIOME_MODIFIER_PHASE_CONVERSIONS.get(entry.getKey());
            Objects.requireNonNull(priority, "priority is null");
            MinecraftForge.EVENT_BUS.addListener(priority, evt -> {
                if (evt.getName() != null) {
                    BiomeLoadingContext filter = BiomeLoadingContextForge.create(BUILT_IN_REGISTRY_ACCESS.get(), (ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)evt.getName()));
                    BiomeModificationContext context = BiomeModificationsContextForgeImpl.createBuilderBackedContext(evt);
                    for (BiomeModification modification : (Collection)entry.getValue()) {
                        modification.tryApply(filter, context);
                    }
                }
            });
        }
    }

    private static BiomeModificationContext createBuilderBackedContext(BiomeLoadingEvent evt) {
        ClimateSettingsContextForge climateSettings = new ClimateSettingsContextForge(() -> ((BiomeLoadingEvent)evt).getClimate(), arg_0 -> ((BiomeLoadingEvent)evt).setClimate(arg_0));
        SpecialEffectsContextForge specialEffects = new SpecialEffectsContextForge(() -> ((BiomeLoadingEvent)evt).getEffects(), arg_0 -> ((BiomeLoadingEvent)evt).setEffects(arg_0));
        GenerationSettingsContextForge generationSettings = new GenerationSettingsContextForge(BUILT_IN_REGISTRY_ACCESS.get(), evt.getGeneration());
        MobSpawnSettingsContextForge mobSpawnSettings = new MobSpawnSettingsContextForge(evt.getSpawns());
        return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
    }

    static RegistryAccess.Writable builtinCopy() {
        RegistryAccess.Writable writable = BiomeModificationsContextForgeImpl.blankWriteable();
        RegistryResourceAccess.InMemoryStorage inMemoryStorage = new RegistryResourceAccess.InMemoryStorage();
        for (Map.Entry entry : RegistryAccess.f_123048_.entrySet()) {
            if (((ResourceKey)entry.getKey()).equals((Object)Registry.f_122818_) || ((ResourceKey)entry.getKey()).equals((Object)Registry.f_122885_)) continue;
            BiomeModificationsContextForgeImpl.addBuiltinElements(inMemoryStorage, (RegistryAccess.RegistryData)entry.getValue());
        }
        RegistryOps.m_206817_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess.Writable)writable, (RegistryResourceAccess)inMemoryStorage);
        return DimensionType.m_204488_((RegistryAccess.Writable)writable);
    }

    private static RegistryAccess.Writable blankWriteable() {
        Method blankWriteable = ObfuscationReflectionHelper.findMethod(RegistryAccess.class, (String)"m_206212_", (Class[])new Class[0]);
        blankWriteable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(blankWriteable).invoke();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static <E> void addBuiltinElements(RegistryResourceAccess.InMemoryStorage pDestinationRegistryHolder, RegistryAccess.RegistryData<E> pData) {
        ResourceKey resourceKey = pData.f_123101_();
        Registry registry = BuiltinRegistries.f_206379_.m_175515_(resourceKey);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey otherResourceKey = (ResourceKey)entry.getKey();
            Object e = entry.getValue();
            pDestinationRegistryHolder.m_206836_(BuiltinRegistries.f_206379_, otherResourceKey, (Encoder)pData.f_123102_(), registry.m_7447_(e), e, registry.m_6228_(e));
        }
    }

    private record BiomeModification(Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        public void tryApply(BiomeLoadingContext filter, BiomeModificationContext context) {
            if (this.selector().test(filter)) {
                this.modifier().accept(context);
            }
        }
    }
}

