/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.core;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicBakingCompletedContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicModifyBakingResultContext;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.DynamicModifyBakingResultContextImpl;
import fuzs.puzzleslib.impl.client.core.context.AdditionalModelsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.AtlasSpritesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockColorProvidersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockEntityRenderersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockRenderTypesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.BuiltinModelItemRendererContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ClientTooltipComponentsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.CoreShadersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.DynamicBakingCompletedContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.EntityRenderersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.FluidRenderTypesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemColorProvidersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemDecorationContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemModelPropertiesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.KeyMappingsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.LayerDefinitionsContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.LivingEntityRenderLayersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ParticleProvidersContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.ResourcePackSourcesContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.SearchRegistryContextForgeImpl;
import fuzs.puzzleslib.impl.client.core.context.SkullRenderersContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextForgeImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class ForgeClientModConstructor {
    private ForgeClientModConstructor() {
    }

    public static void construct(ClientModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ModContainerHelper.findModEventBus(modId).ifPresent(eventBus -> {
            ForgeClientModConstructor.registerModHandlers(constructor, modId, eventBus, Lists.newArrayList(), availableFlags);
            constructor.onConstructMod();
        });
    }

    private static void registerModHandlers(ClientModConstructor constructor, String modId, IEventBus eventBus, List<ResourceManagerReloadListener> dynamicRenderers, Set<ContentRegistrationFlags> availableFlags) {
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onClientSetup();
            constructor.onRegisterSearchTrees(new SearchRegistryContextForgeImpl());
            constructor.onRegisterItemModelProperties(new ItemModelPropertiesContextForgeImpl());
            constructor.onRegisterBuiltinModelItemRenderers(new BuiltinModelItemRendererContextForgeImpl(dynamicRenderers));
            constructor.onRegisterBlockRenderTypes(new BlockRenderTypesContextForgeImpl());
            constructor.onRegisterFluidRenderTypes(new FluidRenderTypesContextForgeImpl());
            constructor.onRegisterClientTooltipComponents(new ClientTooltipComponentsContextForgeImpl());
            constructor.onRegisterKeyMappings(new KeyMappingsContextForgeImpl());
        }));
        eventBus.addListener(evt -> {
            constructor.onRegisterEntityRenderers(new EntityRenderersContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1)));
            constructor.onRegisterBlockEntityRenderers(new BlockEntityRenderersContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1)));
        });
        eventBus.addListener(evt -> constructor.onRegisterParticleProviders(new ParticleProvidersContextForgeImpl()));
        eventBus.addListener(evt -> constructor.onRegisterAtlasSprites(new AtlasSpritesContextForgeImpl(evt.getAtlas(), arg_0 -> ((TextureStitchEvent.Pre)evt).addSprite(arg_0))));
        eventBus.addListener(evt -> constructor.onRegisterLayerDefinitions(new LayerDefinitionsContextForgeImpl((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1))));
        eventBus.addListener(evt -> {
            ForgeClientModConstructor.onModifyBakingResult(constructor::onModifyBakingResult, modId, evt.getModelRegistry(), (ModelBakery)evt.getModelLoader());
            ForgeClientModConstructor.onBakingCompleted(constructor::onBakingCompleted, modId, evt.getModelManager(), Collections.unmodifiableMap(evt.getModelRegistry()), (ModelBakery)evt.getModelLoader());
        });
        eventBus.addListener(evt -> constructor.onRegisterAdditionalModels(new AdditionalModelsContextForgeImpl()));
        eventBus.addListener(evt -> constructor.onRegisterItemDecorations(new ItemDecorationContextForgeImpl(evt::register)));
        eventBus.addListener(evt -> constructor.onRegisterSkullRenderers(new SkullRenderersContextForgeImpl(evt.getEntityModelSet(), (arg_0, arg_1) -> ((EntityRenderersEvent.CreateSkullModels)evt).registerSkullModel(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onRegisterResourcePackReloadListeners(new AddReloadListenersContextForgeImpl(arg_0 -> ((RegisterClientReloadListenersEvent)evt).registerReloadListener(arg_0))));
        eventBus.addListener(evt -> ForgeClientModConstructor.registerBuiltInItemModelRenderersReloadListeners(arg_0 -> ((RegisterClientReloadListenersEvent)evt).registerReloadListener(arg_0), modId, dynamicRenderers, availableFlags));
        eventBus.addListener(evt -> constructor.onRegisterLivingEntityRenderLayers(new LivingEntityRenderLayersContextForgeImpl((EntityRenderersEvent.AddLayers)evt)));
        eventBus.addListener(evt -> constructor.onRegisterBlockColorProviders(new BlockColorProvidersContextForgeImpl((arg_0, arg_1) -> ForgeClientModConstructor.lambda$registerModHandlers$14(evt.getBlockColors(), arg_0, arg_1), evt.getBlockColors())));
        eventBus.addListener(evt -> constructor.onRegisterItemColorProviders(new ItemColorProvidersContextForgeImpl((arg_0, arg_1) -> ForgeClientModConstructor.lambda$registerModHandlers$16(evt.getItemColors(), arg_0, arg_1), evt.getItemColors())));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.CLIENT_RESOURCES) {
                constructor.onAddResourcePackFinders(new ResourcePackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
            }
        });
        eventBus.addListener(evt -> constructor.onRegisterCoreShaders(new CoreShadersContextForgeImpl((arg_0, arg_1) -> ((RegisterShadersEvent)evt).registerShader(arg_0, arg_1), evt.getResourceManager())));
    }

    private static void onBakingCompleted(Consumer<DynamicBakingCompletedContext> consumer, String modId, ModelManager modelManager, Map<ResourceLocation, BakedModel> models, ModelBakery modelBakery) {
        try {
            consumer.accept(new DynamicBakingCompletedContextForgeImpl(modelManager, models, modelBakery));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during baking completed phase provided by {}", (Object)modId, (Object)e);
        }
    }

    private static void onModifyBakingResult(Consumer<DynamicModifyBakingResultContext> consumer, String modId, Map<ResourceLocation, BakedModel> models, ModelBakery modelBakery) {
        try {
            consumer.accept(new DynamicModifyBakingResultContextImpl(models, modelBakery));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during modify baking result phase provided by {}", (Object)modId, (Object)e);
        }
    }

    private static void registerBuiltInItemModelRenderersReloadListeners(Consumer<PreparableReloadListener> consumer, String modId, List<ResourceManagerReloadListener> dynamicRenderers, Set<ContentRegistrationFlags> availableFlags) {
        if (availableFlags.contains((Object)ContentRegistrationFlags.DYNAMIC_RENDERERS)) {
            consumer.accept((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
                for (ResourceManagerReloadListener listener : dynamicRenderers) {
                    try {
                        listener.m_6213_(resourceManager);
                    }
                    catch (Exception e) {
                        PuzzlesLib.LOGGER.error("Unable to execute dynamic built-in model item renderers reload provided by {}", (Object)modId, (Object)e);
                    }
                }
            }));
        }
    }

    private static /* synthetic */ void lambda$registerModHandlers$16(ItemColors rec$, ItemColor x$0, ItemLike xva$1) {
        rec$.m_92689_(x$0, new ItemLike[]{xva$1});
    }

    private static /* synthetic */ void lambda$registerModHandlers$14(BlockColors rec$, BlockColor x$0, Block xva$1) {
        rec$.m_92589_(x$0, new Block[]{xva$1});
    }
}

