/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class JsonCodecProvider<T>
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator output;
    protected final ExistingFileHelper existingFileHelper;
    protected final String modid;
    protected final DynamicOps<JsonElement> dynamicOps;
    protected final PackType packType;
    protected final String directory;
    protected final Codec<T> codec;
    protected final Map<ResourceLocation, T> entries;

    public JsonCodecProvider(DataGenerator output, ExistingFileHelper existingFileHelper, String modid, DynamicOps<JsonElement> dynamicOps, PackType packType, String directory, Codec<T> codec, Map<ResourceLocation, T> entries) {
        ExistingFileHelper.ResourceType resourceType = new ExistingFileHelper.ResourceType(packType, ".json", directory);
        for (ResourceLocation id : entries.keySet()) {
            existingFileHelper.trackGenerated(id, (ExistingFileHelper.IResourceType)resourceType);
        }
        this.output = output;
        this.existingFileHelper = existingFileHelper;
        this.modid = modid;
        this.dynamicOps = dynamicOps;
        this.packType = packType;
        this.directory = directory;
        this.codec = codec;
        this.entries = entries;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path outputFolder = this.output.m_123916_().resolve(this.packType.m_10305_());
        this.gather(LamdbaExceptionUtils.rethrowBiConsumer((id, value) -> {
            Path path = outputFolder.resolve(id.m_135827_()).resolve(this.directory).resolve(id.m_135815_() + ".json");
            JsonElement encoded = (JsonElement)this.codec.encodeStart(this.dynamicOps, value).getOrThrow(false, msg -> LOGGER.error("Failed to encode {}: {}", (Object)path, msg));
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)encoded, (Path)path);
        }));
    }

    protected void gather(BiConsumer<ResourceLocation, T> consumer) {
        this.entries.forEach(consumer);
    }

    public String m_6055_() {
        return String.format("%s generator for %s", this.directory, this.modid);
    }
}

