/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1.context;

import fuzs.puzzleslib.api.item.v2.DisplayItemsOutput;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public interface BuildCreativeModeTabContentsContext {
    @Nullable
    public static ResourceLocation tryCreateIdentifier(CreativeModeTab tab) {
        String identifier = ((TranslatableComponent)tab.m_40786_()).m_131328_().substring("itemGroup.".length()).replace(".", ":");
        return ResourceLocation.m_135820_((String)identifier.toLowerCase(Locale.ROOT));
    }

    @Nullable
    public static CreativeModeTab findFromIdentifier(ResourceLocation identifier) {
        for (CreativeModeTab tab : CreativeModeTab.f_40748_) {
            if (!identifier.equals((Object)BuildCreativeModeTabContentsContext.tryCreateIdentifier(tab))) continue;
            return tab;
        }
        return null;
    }

    default public void registerBuildListener(String modId, Consumer<DisplayItemsOutput> itemsGenerator) {
        ResourceLocation identifier = new ResourceLocation(modId, "main");
        this.registerBuildListener(identifier, itemsGenerator);
    }

    default public void registerBuildListener(ResourceLocation identifier, Consumer<DisplayItemsOutput> itemsGenerator) {
        CreativeModeTab tab = BuildCreativeModeTabContentsContext.findFromIdentifier(identifier);
        if (tab != null) {
            this.registerBuildListener(tab, itemsGenerator);
        }
    }

    default public void registerBuildListener(CreativeModeTab tab, Consumer<DisplayItemsOutput> itemsGenerator) {
        Objects.requireNonNull(tab, "creative mode tab is null");
        Objects.requireNonNull(itemsGenerator, "display items generator is null");
        itemsGenerator.accept(DisplayItemsOutput.setItemCategory(tab));
    }
}

