/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.screen.v2;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public final class TooltipRenderHelper
extends GuiComponent {
    private TooltipRenderHelper() {
    }

    public static List<Component> getTooltipLines(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<Component> getTooltipLines(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        return itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, tooltipFlag);
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<Component> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<TooltipComponent> imageComponents = itemStack.m_150921_().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(PoseStack poseStack, int posX, int posY, ItemStack itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipInternal(poseStack, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(PoseStack poseStack, int posX, int posY, Component component, TooltipComponent imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(poseStack, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(PoseStack poseStack, int posX, int posY, List<Component> components, TooltipComponent imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(poseStack, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(PoseStack poseStack, int posX, int posY, List<Component> components) {
        TooltipRenderHelper.renderTooltip(poseStack, posX, posY, components, List.of());
    }

    public static void renderTooltip(PoseStack poseStack, int posX, int posY, List<Component> components, List<TooltipComponent> imageComponents) {
        TooltipRenderHelper.renderTooltipInternal(poseStack, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList());
        List<ClientTooltipComponent> clientImageComponents = imageComponents.stream().map(ClientAbstractions.INSTANCE::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(insertAt, clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    public static void renderTooltipInternal(PoseStack poseStack, int posX, int posY, List<ClientTooltipComponent> components) {
        ClientTooltipComponent clientTooltipComponent2;
        int q;
        if (components.isEmpty()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component : components) {
            int k = component.m_142069_(font);
            if (k > i) {
                i = k;
            }
            j += component.m_142103_();
        }
        int l = posX + 12;
        int m = posY - 12;
        poseStack.m_85836_();
        float f = itemRenderer.f_115093_;
        itemRenderer.f_115093_ = 400.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 3), (int)(m - 4), (int)(l + i + 3), (int)(m - 3), (int)400, (int)-267386864, (int)-267386864);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 3), (int)(m + j + 3), (int)(l + i + 3), (int)(m + j + 4), (int)400, (int)-267386864, (int)-267386864);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 3), (int)(m - 3), (int)(l + i + 3), (int)(m + j + 3), (int)400, (int)-267386864, (int)-267386864);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 4), (int)(m - 3), (int)(l - 3), (int)(m + j + 3), (int)400, (int)-267386864, (int)-267386864);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l + i + 3), (int)(m - 3), (int)(l + i + 4), (int)(m + j + 3), (int)400, (int)-267386864, (int)-267386864);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 3), (int)(m - 3 + 1), (int)(l - 3 + 1), (int)(m + j + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l + i + 2), (int)(m - 3 + 1), (int)(l + i + 3), (int)(m + j + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 3), (int)(m - 3), (int)(l + i + 3), (int)(m - 3 + 1), (int)400, (int)0x505000FF, (int)0x505000FF);
        TooltipRenderHelper.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(l - 3), (int)(m + j + 2), (int)(l + i + 3), (int)(m + j + 3), (int)400, (int)1344798847, (int)1344798847);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int p = m;
        for (q = 0; q < components.size(); ++q) {
            clientTooltipComponent2 = components.get(q);
            clientTooltipComponent2.m_142440_(font, l, p, matrix4f, bufferSource);
            p += clientTooltipComponent2.m_142103_() + (q == 0 ? 2 : 0);
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        p = m;
        for (q = 0; q < components.size(); ++q) {
            clientTooltipComponent2 = components.get(q);
            clientTooltipComponent2.m_183452_(font, l, p, poseStack, itemRenderer, 400);
            p += clientTooltipComponent2.m_142103_() + (q == 0 ? 2 : 0);
        }
        itemRenderer.f_115093_ = f;
    }
}

