/*
 * Decompiled with CFR 0.152.
 */
package net.redgitreds.inferno.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.redgitreds.inferno.InfernoMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfernoModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        InfernoMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        InfernoMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Chestplate = message.data.Chestplate;
                    variables.helm = message.data.helm;
                    variables.leg = message.data.leg;
                    variables.boot = message.data.boot;
                    variables.helmopen = message.data.helmopen;
                    variables.helm2 = message.data.helm2;
                    variables.chesplateno = message.data.chesplateno;
                    variables.chestplateyes = message.data.chestplateyes;
                    variables.helmetyes = message.data.helmetyes;
                    variables.helmetno = message.data.helmetno;
                    variables.legyes = message.data.legyes;
                    variables.legno = message.data.legno;
                    variables.bootyes = message.data.bootyes;
                    variables.bootno = message.data.bootno;
                    variables.Xvar = message.data.Xvar;
                    variables.Yvar = message.data.Yvar;
                    variables.Zvar = message.data.Zvar;
                    variables.vardmg = message.data.vardmg;
                    variables.deatharm = message.data.deatharm;
                    variables.repsawn = message.data.repsawn;
                    variables.respawn2 = message.data.respawn2;
                    variables.respawn3 = message.data.respawn3;
                    variables.respawn4 = message.data.respawn4;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public ItemStack Chestplate = ItemStack.f_41583_;
        public ItemStack helm = ItemStack.f_41583_;
        public ItemStack leg = ItemStack.f_41583_;
        public ItemStack boot = ItemStack.f_41583_;
        public ItemStack helmopen = ItemStack.f_41583_;
        public ItemStack helm2 = ItemStack.f_41583_;
        public ItemStack chesplateno = ItemStack.f_41583_;
        public ItemStack chestplateyes = ItemStack.f_41583_;
        public ItemStack helmetyes = ItemStack.f_41583_;
        public ItemStack helmetno = ItemStack.f_41583_;
        public ItemStack legyes = ItemStack.f_41583_;
        public ItemStack legno = ItemStack.f_41583_;
        public ItemStack bootyes = ItemStack.f_41583_;
        public ItemStack bootno = ItemStack.f_41583_;
        public double Xvar = 0.0;
        public double Yvar = 0.0;
        public double Zvar = 0.0;
        public double vardmg = 0.0;
        public double deatharm = 0.0;
        public ItemStack repsawn = ItemStack.f_41583_;
        public ItemStack respawn2 = ItemStack.f_41583_;
        public ItemStack respawn3 = ItemStack.f_41583_;
        public ItemStack respawn4 = ItemStack.f_41583_;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                InfernoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Chestplate", (Tag)this.Chestplate.m_41739_(new CompoundTag()));
            nbt.m_128365_("helm", (Tag)this.helm.m_41739_(new CompoundTag()));
            nbt.m_128365_("leg", (Tag)this.leg.m_41739_(new CompoundTag()));
            nbt.m_128365_("boot", (Tag)this.boot.m_41739_(new CompoundTag()));
            nbt.m_128365_("helmopen", (Tag)this.helmopen.m_41739_(new CompoundTag()));
            nbt.m_128365_("helm2", (Tag)this.helm2.m_41739_(new CompoundTag()));
            nbt.m_128365_("chesplateno", (Tag)this.chesplateno.m_41739_(new CompoundTag()));
            nbt.m_128365_("chestplateyes", (Tag)this.chestplateyes.m_41739_(new CompoundTag()));
            nbt.m_128365_("helmetyes", (Tag)this.helmetyes.m_41739_(new CompoundTag()));
            nbt.m_128365_("helmetno", (Tag)this.helmetno.m_41739_(new CompoundTag()));
            nbt.m_128365_("legyes", (Tag)this.legyes.m_41739_(new CompoundTag()));
            nbt.m_128365_("legno", (Tag)this.legno.m_41739_(new CompoundTag()));
            nbt.m_128365_("bootyes", (Tag)this.bootyes.m_41739_(new CompoundTag()));
            nbt.m_128365_("bootno", (Tag)this.bootno.m_41739_(new CompoundTag()));
            nbt.m_128347_("Xvar", this.Xvar);
            nbt.m_128347_("Yvar", this.Yvar);
            nbt.m_128347_("Zvar", this.Zvar);
            nbt.m_128347_("vardmg", this.vardmg);
            nbt.m_128347_("deatharm", this.deatharm);
            nbt.m_128365_("repsawn", (Tag)this.repsawn.m_41739_(new CompoundTag()));
            nbt.m_128365_("respawn2", (Tag)this.respawn2.m_41739_(new CompoundTag()));
            nbt.m_128365_("respawn3", (Tag)this.respawn3.m_41739_(new CompoundTag()));
            nbt.m_128365_("respawn4", (Tag)this.respawn4.m_41739_(new CompoundTag()));
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.Chestplate = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Chestplate"));
            this.helm = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helm"));
            this.leg = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("leg"));
            this.boot = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("boot"));
            this.helmopen = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helmopen"));
            this.helm2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helm2"));
            this.chesplateno = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("chesplateno"));
            this.chestplateyes = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("chestplateyes"));
            this.helmetyes = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helmetyes"));
            this.helmetno = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helmetno"));
            this.legyes = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("legyes"));
            this.legno = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("legno"));
            this.bootyes = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("bootyes"));
            this.bootno = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("bootno"));
            this.Xvar = nbt.m_128459_("Xvar");
            this.Yvar = nbt.m_128459_("Yvar");
            this.Zvar = nbt.m_128459_("Zvar");
            this.vardmg = nbt.m_128459_("vardmg");
            this.deatharm = nbt.m_128459_("deatharm");
            this.repsawn = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("repsawn"));
            this.respawn2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("respawn2"));
            this.respawn3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("respawn3"));
            this.respawn4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("respawn4"));
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("inferno", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "inferno_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                InfernoMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_142572_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "inferno_worldvars";
        public double scale1cd = 0.0;
        public double scalecd1 = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.scale1cd = nbt.m_128459_("scale1cd");
            this.scalecd1 = nbt.m_128459_("scalecd1");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("scale1cd", this.scale1cd);
            nbt.m_128347_("scalecd1", this.scalecd1);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                InfernoMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Chestplate = original.Chestplate;
            clone.helm = original.helm;
            clone.leg = original.leg;
            clone.boot = original.boot;
            clone.helmopen = original.helmopen;
            clone.helm2 = original.helm2;
            clone.chesplateno = original.chesplateno;
            clone.chestplateyes = original.chestplateyes;
            clone.helmetyes = original.helmetyes;
            clone.helmetno = original.helmetno;
            clone.legyes = original.legyes;
            clone.legno = original.legno;
            clone.bootyes = original.bootyes;
            clone.bootno = original.bootno;
            clone.Xvar = original.Xvar;
            clone.Yvar = original.Yvar;
            clone.Zvar = original.Zvar;
            clone.vardmg = original.vardmg;
            clone.deatharm = original.deatharm;
            clone.repsawn = original.repsawn;
            clone.respawn2 = original.respawn2;
            clone.respawn3 = original.respawn3;
            clone.respawn4 = original.respawn4;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                if (mapdata != null) {
                    InfernoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    InfernoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getPlayer().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_)) != null) {
                InfernoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

