/*
 * Decompiled with CFR 0.152.
 */
package net.redgitreds.inferno.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.redgitreds.inferno.world.features.CustomFeature;
import net.redgitreds.inferno.world.features.Customunder1Feature;
import net.redgitreds.inferno.world.features.Customunder2Feature;
import net.redgitreds.inferno.world.features.Customunder3Feature;
import net.redgitreds.inferno.world.features.Customunder4Feature;
import net.redgitreds.inferno.world.features.Customunder5Feature;
import net.redgitreds.inferno.world.features.CustomunderFeature;
import net.redgitreds.inferno.world.features.DNFeature;
import net.redgitreds.inferno.world.features.DragonHuntingShipFeature;
import net.redgitreds.inferno.world.features.DragonWaterFeature;
import net.redgitreds.inferno.world.features.GFeature;
import net.redgitreds.inferno.world.features.HZFeature;
import net.redgitreds.inferno.world.features.LFFeature;
import net.redgitreds.inferno.world.features.MNFeature;
import net.redgitreds.inferno.world.features.NFFeature;
import net.redgitreds.inferno.world.features.SFeature;
import net.redgitreds.inferno.world.features.SKFeature;
import net.redgitreds.inferno.world.features.TSFeature;
import net.redgitreds.inferno.world.features.TTFeature;

@Mod.EventBusSubscriber
public class InfernoModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"inferno");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> NF = InfernoModFeatures.register("nf", NFFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, NFFeature.GENERATE_BIOMES, NFFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TT = InfernoModFeatures.register("tt", TTFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, TTFeature.GENERATE_BIOMES, TTFeature::placedFeature));
    public static final RegistryObject<Feature<?>> S = InfernoModFeatures.register("s", SFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SFeature.GENERATE_BIOMES, SFeature::placedFeature));
    public static final RegistryObject<Feature<?>> G = InfernoModFeatures.register("g", GFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GFeature.GENERATE_BIOMES, GFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HZ = InfernoModFeatures.register("hz", HZFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, HZFeature.GENERATE_BIOMES, HZFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DN = InfernoModFeatures.register("dn", DNFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, DNFeature.GENERATE_BIOMES, DNFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LF = InfernoModFeatures.register("lf", LFFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, LFFeature.GENERATE_BIOMES, LFFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TS = InfernoModFeatures.register("ts", TSFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, TSFeature.GENERATE_BIOMES, TSFeature::placedFeature));
    public static final RegistryObject<Feature<?>> MN = InfernoModFeatures.register("mn", MNFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, MNFeature.GENERATE_BIOMES, MNFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SK = InfernoModFeatures.register("sk", SKFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SKFeature.GENERATE_BIOMES, SKFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DRAGON_HUNTING_SHIP = InfernoModFeatures.register("dragon_hunting_ship", DragonHuntingShipFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, DragonHuntingShipFeature.GENERATE_BIOMES, DragonHuntingShipFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DRAGON_WATER = InfernoModFeatures.register("dragon_water", DragonWaterFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, DragonWaterFeature.GENERATE_BIOMES, DragonWaterFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOM = InfernoModFeatures.register("custom", CustomFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CustomFeature.GENERATE_BIOMES, CustomFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOMUNDER = InfernoModFeatures.register("customunder", CustomunderFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CustomunderFeature.GENERATE_BIOMES, CustomunderFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOMUNDER_1 = InfernoModFeatures.register("customunder_1", Customunder1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Customunder1Feature.GENERATE_BIOMES, Customunder1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOMUNDER_2 = InfernoModFeatures.register("customunder_2", Customunder2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Customunder2Feature.GENERATE_BIOMES, Customunder2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOMUNDER_3 = InfernoModFeatures.register("customunder_3", Customunder3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Customunder3Feature.GENERATE_BIOMES, Customunder3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOMUNDER_4 = InfernoModFeatures.register("customunder_4", Customunder4Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Customunder4Feature.GENERATE_BIOMES, Customunder4Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CUSTOMUNDER_5 = InfernoModFeatures.register("customunder_5", Customunder5Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Customunder5Feature.GENERATE_BIOMES, Customunder5Feature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

