/*
 * Decompiled with CFR 0.152.
 */
package net.redgitreds.inferno.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.redgitreds.inferno.entity.DeadlyNadderHeadEntity;
import net.redgitreds.inferno.entity.FireBombEntity;
import net.redgitreds.inferno.entity.GronckleHeadEntity;
import net.redgitreds.inferno.entity.LightFuryHeadEntity;
import net.redgitreds.inferno.entity.MNightmareHeadEntity;
import net.redgitreds.inferno.entity.NadderSpineEntity;
import net.redgitreds.inferno.entity.NightFuryHeadEntity;
import net.redgitreds.inferno.entity.PillagerDragonHunterEntity;
import net.redgitreds.inferno.entity.SkrillHeadEntity;
import net.redgitreds.inferno.entity.SpeedStingerHeadEntity;
import net.redgitreds.inferno.entity.StingerHeadEntity;
import net.redgitreds.inferno.entity.TerribleTerrorHeadEntity;
import net.redgitreds.inferno.entity.TripleStrykeHeadEntity;
import net.redgitreds.inferno.entity.ZippleBackHeadEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfernoModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"inferno");
    public static final RegistryObject<EntityType<NadderSpineEntity>> NADDER_SPINE = InfernoModEntities.register("projectile_nadder_spine", EntityType.Builder.m_20704_(NadderSpineEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(NadderSpineEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<FireBombEntity>> FIRE_BOMB = InfernoModEntities.register("projectile_fire_bomb", EntityType.Builder.m_20704_(FireBombEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FireBombEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SpeedStingerHeadEntity>> SPEED_STINGER_HEAD = InfernoModEntities.register("speed_stinger_head", EntityType.Builder.m_20704_(SpeedStingerHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(SpeedStingerHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<StingerHeadEntity>> STINGER_HEAD = InfernoModEntities.register("stinger_head", EntityType.Builder.m_20704_(StingerHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(StingerHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<TerribleTerrorHeadEntity>> TERRIBLE_TERROR_HEAD = InfernoModEntities.register("terrible_terror_head", EntityType.Builder.m_20704_(TerribleTerrorHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(TerribleTerrorHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<DeadlyNadderHeadEntity>> DEADLY_NADDER_HEAD = InfernoModEntities.register("deadly_nadder_head", EntityType.Builder.m_20704_(DeadlyNadderHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(DeadlyNadderHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<TripleStrykeHeadEntity>> TRIPLE_STRYKE_HEAD = InfernoModEntities.register("triple_stryke_head", EntityType.Builder.m_20704_(TripleStrykeHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(TripleStrykeHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<ZippleBackHeadEntity>> ZIPPLE_BACK_HEAD = InfernoModEntities.register("zipple_back_head", EntityType.Builder.m_20704_(ZippleBackHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(ZippleBackHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<MNightmareHeadEntity>> M_NIGHTMARE_HEAD = InfernoModEntities.register("m_nightmare_head", EntityType.Builder.m_20704_(MNightmareHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(MNightmareHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<LightFuryHeadEntity>> LIGHT_FURY_HEAD = InfernoModEntities.register("light_fury_head", EntityType.Builder.m_20704_(LightFuryHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(LightFuryHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<NightFuryHeadEntity>> NIGHT_FURY_HEAD = InfernoModEntities.register("night_fury_head", EntityType.Builder.m_20704_(NightFuryHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(NightFuryHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<GronckleHeadEntity>> GRONCKLE_HEAD = InfernoModEntities.register("gronckle_head", EntityType.Builder.m_20704_(GronckleHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(GronckleHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<SkrillHeadEntity>> SKRILL_HEAD = InfernoModEntities.register("skrill_head", EntityType.Builder.m_20704_(SkrillHeadEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(SkrillHeadEntity::new).m_20719_().m_20699_(0.8f, 0.8f));
    public static final RegistryObject<EntityType<PillagerDragonHunterEntity>> PILLAGER_DRAGON_HUNTER = InfernoModEntities.register("pillager_dragon_hunter", EntityType.Builder.m_20704_(PillagerDragonHunterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PillagerDragonHunterEntity::new).m_20719_().m_20699_(0.6f, 1.95f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SpeedStingerHeadEntity.init();
            StingerHeadEntity.init();
            TerribleTerrorHeadEntity.init();
            DeadlyNadderHeadEntity.init();
            TripleStrykeHeadEntity.init();
            ZippleBackHeadEntity.init();
            MNightmareHeadEntity.init();
            LightFuryHeadEntity.init();
            NightFuryHeadEntity.init();
            GronckleHeadEntity.init();
            SkrillHeadEntity.init();
            PillagerDragonHunterEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPEED_STINGER_HEAD.get(), SpeedStingerHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)STINGER_HEAD.get(), StingerHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)TERRIBLE_TERROR_HEAD.get(), TerribleTerrorHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)DEADLY_NADDER_HEAD.get(), DeadlyNadderHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)TRIPLE_STRYKE_HEAD.get(), TripleStrykeHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)ZIPPLE_BACK_HEAD.get(), ZippleBackHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)M_NIGHTMARE_HEAD.get(), MNightmareHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)LIGHT_FURY_HEAD.get(), LightFuryHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)NIGHT_FURY_HEAD.get(), NightFuryHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)GRONCKLE_HEAD.get(), GronckleHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)SKRILL_HEAD.get(), SkrillHeadEntity.createAttributes().m_22265_());
        event.put((EntityType)PILLAGER_DRAGON_HUNTER.get(), PillagerDragonHunterEntity.createAttributes().m_22265_());
    }
}

