/*
 * Decompiled with CFR 0.152.
 */
package com.github.channelingmc.visuality.data;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.nbt.NbtOps;

public class CompactListCodec<A>
implements Codec<List<A>> {
    private final Codec<A> elementCodec;
    private final Codec<List<A>> listCodec;

    public CompactListCodec(Codec<A> elementCodec) {
        this.elementCodec = elementCodec;
        this.listCodec = elementCodec.listOf();
    }

    public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops instanceof NbtOps || ops.getStream(input).error().isEmpty()) {
            return this.listCodec.decode(ops, input);
        }
        return this.elementCodec.parse(ops, input).map(a -> Pair.of((Object)Lists.newArrayList((Object[])new Object[]{a}), (Object)input));
    }

    public <T> DataResult<T> encode(List<A> input, DynamicOps<T> ops, T prefix) {
        if (ops instanceof NbtOps || input.size() != 1 || prefix != ops.empty()) {
            return this.listCodec.encode(input, ops, prefix);
        }
        return this.elementCodec.encodeStart(ops, input.get(0));
    }
}

