/*
 * Decompiled with CFR 0.152.
 */
package com.github.channelingmc.visuality.config.entity;

import com.github.channelingmc.visuality.Visuality;
import com.github.channelingmc.visuality.config.ReloadableJsonConfig;
import com.github.channelingmc.visuality.data.Particle;
import com.github.channelingmc.visuality.data.VisualityCodecs;
import com.github.channelingmc.visuality.particle.type.VisualityParticleTypes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntityHitParticles
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int minAmount = 1;
    private int maxAmount = 20;
    private List<Entry> entries;
    private final IdentityHashMap<EntityType<?>, Particle> particles = new IdentityHashMap();

    public EntityHitParticles() {
        super(Visuality.loc("particle_emitters/entity/hit"));
        this.entries = EntityHitParticles.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (EntityType<?> type : entry.entities) {
                this.particles.put(type, entry.particle);
            }
        }
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::spawnHitParticles);
    }

    public void spawnHitParticles(LivingAttackEvent event) {
        if (!this.enabled) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer attacker = (AbstractClientPlayer)entity;
        LivingEntity entity2 = event.getEntityLiving();
        EntityType type = entity2.m_6095_();
        if (!this.particles.containsKey(type) || entity2.m_6673_(source) || entity2.m_21224_() || source.m_19384_() && entity2.m_21023_(MobEffects.f_19607_)) {
            return;
        }
        Collection modifiers = attacker.m_21205_().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
        double addition = 0.0;
        double multiplyBase = 1.0;
        double multiplyTotal = 1.0;
        for (AttributeModifier modifier : modifiers) {
            switch (modifier.m_22217_()) {
                case ADDITION: {
                    addition += modifier.m_22218_();
                    break;
                }
                case MULTIPLY_BASE: {
                    multiplyBase += modifier.m_22218_();
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multiplyTotal *= 1.0 + modifier.m_22218_();
                }
            }
        }
        double amount = (double)event.getAmount() * (1.0 + addition) * multiplyBase * multiplyTotal;
        if (amount <= 0.0) {
            return;
        }
        Particle particle = this.particles.get(entity2.m_6095_());
        int count = Mth.m_14045_((int)((int)Math.sqrt(amount)), (int)this.minAmount, (int)this.maxAmount);
        double x = entity2.m_20185_();
        double y = entity2.m_20227_(0.5);
        double z = entity2.m_20189_();
        for (int i = 0; i < count; ++i) {
            particle.spawn(entity2.f_19853_, x, y, z);
        }
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.m_6180_(source);
        if (config) {
            this.enabled = GsonHelper.m_13855_((JsonObject)input, (String)"enabled", (boolean)true);
            this.minAmount = GsonHelper.m_13824_((JsonObject)input, (String)"min_amount", (int)1);
            this.maxAmount = GsonHelper.m_13824_((JsonObject)input, (String)"max_amount", (int)20);
        }
        if ((array = GsonHelper.m_13832_((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.m_7238_();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.PartialResult)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (EntityType<?> type : entry.entities) {
                this.particles.put(type, entry.particle);
            }
        }
        profiler.m_7238_();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("min_amount", (Number)this.minAmount);
        object.addProperty("max_amount", (Number)this.maxAmount);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(true, msg -> this.logger.error("Failed to serialize config entries: {}", msg)));
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(Entry.of(List.of(EntityType.f_20524_, EntityType.f_20525_, EntityType.f_20481_), (ParticleOptions)VisualityParticleTypes.BONE.get()));
        entries.add(Entry.of(EntityType.f_20497_, (ParticleOptions)VisualityParticleTypes.WITHER_BONE.get()));
        entries.add(Entry.of(EntityType.f_20555_, (ParticleOptions)VisualityParticleTypes.FEATHER.get()));
        entries.add(Entry.of(List.of(EntityType.f_20492_, EntityType.f_20494_), (ParticleOptions)VisualityParticleTypes.EMERALD.get()));
        return entries;
    }

    private record Entry(List<EntityType<?>> entities, Particle particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compactListOf(ForgeRegistries.ENTITIES.getCodec()).fieldOf("entity").forGetter(Entry::entities), (App)Particle.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(List<EntityType<?>> types, ParticleOptions particle) {
            return new Entry(types, Particle.ofZeroVelocity(particle));
        }

        private static Entry of(EntityType<?> type, ParticleOptions particle) {
            return new Entry(List.of(type), Particle.ofZeroVelocity(particle));
        }
    }
}

