/*
 * Decompiled with CFR 0.152.
 */
package com.github.channelingmc.visuality.config.block;

import com.github.channelingmc.visuality.Visuality;
import com.github.channelingmc.visuality.config.ReloadableJsonConfig;
import com.github.channelingmc.visuality.data.Particle;
import com.github.channelingmc.visuality.data.VisualityCodecs;
import com.github.channelingmc.visuality.particle.type.VisualityParticleTypes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BlockStepParticles
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int interval = 10;
    private List<Entry> entries;
    private final IdentityHashMap<Block, Particle> particles = new IdentityHashMap();

    public BlockStepParticles() {
        super(Visuality.loc("particle_emitters/block/step"));
        this.entries = BlockStepParticles.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (Block block : entry.blocks) {
                this.particles.put(block, entry.particle);
            }
        }
    }

    public int interval() {
        return this.interval;
    }

    public void spawnParticles(int amount, Level level, BlockState state, BlockPos pos, Entity entity) {
        if (!this.enabled || entity.m_20161_()) {
            return;
        }
        Block block = state.m_60734_();
        if (!this.particles.containsKey(block)) {
            return;
        }
        Particle particle = this.particles.get(block);
        double y = entity.m_20186_() + 0.0625;
        for (int i = 0; i < amount; ++i) {
            double x = (double)pos.m_123341_() + level.f_46441_.nextDouble();
            double z = (double)pos.m_123343_() + level.f_46441_.nextDouble();
            particle.spawn(level, x, y, z);
        }
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.m_6180_(source);
        if (config) {
            this.enabled = GsonHelper.m_13855_((JsonObject)input, (String)"enabled", (boolean)true);
            this.interval = GsonHelper.m_13824_((JsonObject)input, (String)"interval", (int)10);
        }
        if ((array = GsonHelper.m_13832_((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.m_7238_();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.PartialResult)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (Block block : entry.blocks) {
                this.particles.put(block, entry.particle);
            }
        }
        profiler.m_7238_();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("interval", (Number)this.interval);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(true, msg -> this.logger.error("Failed to serialize config entries: {}", msg)));
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        SimpleParticleType soul = (SimpleParticleType)VisualityParticleTypes.SOUL.get();
        entries.add(Entry.of(List.of(Blocks.f_50135_, Blocks.f_50136_), (ParticleOptions)soul));
        return entries;
    }

    private record Entry(List<Block> blocks, Particle particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compactListOf(ForgeRegistries.BLOCKS.getCodec()).fieldOf("block").forGetter(Entry::blocks), (App)Particle.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(Block block, ParticleOptions particle) {
            return new Entry(List.of(block), Particle.ofZeroVelocity(particle));
        }

        static Entry of(List<Block> blocks, ParticleOptions particle) {
            return new Entry(blocks, Particle.ofZeroVelocity(particle));
        }
    }
}

