/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class WatcherSwordItem
extends SwordItem {
    private static int stepMod = 0;

    public WatcherSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.f_19853_.m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.f_19853_;
            int thitchance = (int)SimplySwordsConfig.getFloatValue("watcher_chance");
            int phitchance = (int)SimplySwordsConfig.getFloatValue("omen_chance");
            boolean impactsounds_enabled = SimplySwordsConfig.getBooleanValue("enable_weapon_impact_sounds");
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 40 && choose_sound > 30) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
            }
            if (attacker.m_21187_().nextInt(100) <= thitchance) {
                target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.WATCHER.get(), 1, 1), (Entity)attacker);
            }
            if (attacker.m_21187_().nextInt(100) <= phitchance) {
                target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.OMEN.get(), 1, 1), (Entity)attacker);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123809_, ParticleTypes.f_123809_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip1").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip2"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip3", new Object[]{Float.valueOf(SimplySwordsConfig.getFloatValue("omen_instantkill_threshold") * 100.0f)}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip4"));
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip5").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip6"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.watchersworditem.tooltip7"));
    }
}

