/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class StealSwordItem
extends SwordItem {
    private static int stepMod = 0;

    public StealSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.f_19853_.m_5776_()) {
            int choose_sound;
            ServerLevel sworld = (ServerLevel)attacker.f_19853_;
            int fhitchance = (int)SimplySwordsConfig.getFloatValue("steal_chance");
            int fduration = (int)SimplySwordsConfig.getFloatValue("steal_duration");
            attacker.m_20256_(attacker.m_20154_().m_82490_(1.0));
            attacker.f_19864_ = true;
            boolean impactsounds_enabled = SimplySwordsConfig.getBooleanValue("enable_weapon_impact_sounds");
            if (impactsounds_enabled) {
                choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 40 && choose_sound > 30) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
            }
            if (attacker.m_21187_().nextInt(100) <= fhitchance) {
                choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, 0.5f, 2.0f);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, 0.5f, 2.0f);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    sworld.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, 0.5f, 2.0f);
                }
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 2), (Entity)attacker);
                target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, fduration, 1), (Entity)attacker);
                target.m_147207_(new MobEffectInstance(MobEffects.f_19619_, fduration, 1), (Entity)attacker);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.f_19853_.m_5776_()) {
            int sradius = (int)SimplySwordsConfig.getFloatValue("steal_radius");
            int vradius = (int)(SimplySwordsConfig.getFloatValue("steal_radius") / 2.0f);
            double x = user.m_20185_();
            double y = user.m_20186_();
            double z = user.m_20189_();
            ServerLevel sworld = (ServerLevel)user.f_19853_;
            AABB box = new AABB(x + (double)sradius, y + (double)vradius, z + (double)sradius, x - (double)sradius, y - (double)vradius, z - (double)sradius);
            for (Entity entities : sworld.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, user)) continue;
                int iduration = (int)SimplySwordsConfig.getFloatValue("steal_invis_duration");
                int bduration = (int)SimplySwordsConfig.getFloatValue("steal_blind_duration");
                if (le.m_21023_(MobEffects.f_19597_) && le.m_21023_(MobEffects.f_19619_) && le.m_20270_((Entity)user) > 5.0f) {
                    le.m_147207_(new MobEffectInstance(MobEffects.f_19610_, bduration, 1), (Entity)user);
                    user.m_20324_(le.m_20185_(), le.m_20186_(), le.m_20189_());
                    sworld.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_03.get(), SoundSource.PLAYERS, 0.3f, 1.5f);
                    le.m_6469_(DamageSource.f_146701_, 5.0f);
                    le.m_21195_(MobEffects.f_19597_);
                    le.m_21195_(MobEffects.f_19619_);
                }
                if (!le.m_21023_(MobEffects.f_19597_) || !le.m_21023_(MobEffects.f_19619_) || !(le.m_20270_((Entity)user) <= 5.0f)) continue;
                user.m_147207_(new MobEffectInstance(MobEffects.f_19609_, iduration, 1), (Entity)user);
                user.m_20256_(user.m_20154_().m_82490_(2.0));
                user.f_19864_ = true;
                sworld.m_6269_(null, entities, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_MISS_01.get(), SoundSource.PLAYERS, 0.3f, 1.5f);
                le.m_21195_(MobEffects.f_19597_);
                le.m_21195_(MobEffects.f_19619_);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123775_, ParticleTypes.f_123775_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip1").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip2"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip3"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip4"));
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.onrightclick").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip5"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip6"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip7"));
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip8"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip9"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.stealsworditem.tooltip10"));
        tooltip.add((Component)new TextComponent(""));
    }
}

