/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class HasteSwordItem
extends SwordItem {
    private static int stepMod = 0;

    public HasteSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.f_19853_.m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.f_19853_;
            int fhitchance = (int)SimplySwordsConfig.getFloatValue("ferocity_chance");
            int fduration = (int)SimplySwordsConfig.getFloatValue("ferocity_duration");
            int maximum_stacks = (int)SimplySwordsConfig.getFloatValue("ferocity_max_stacks");
            boolean impactsounds_enabled = SimplySwordsConfig.getBooleanValue("enable_weapon_impact_sounds");
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 40 && choose_sound > 30) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
            }
            if (attacker.m_21187_().nextInt(100) <= fhitchance) {
                if (attacker.m_21023_(MobEffects.f_19598_)) {
                    int a = attacker.m_21124_(MobEffects.f_19598_).m_19564_() + 1;
                    world.m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_02.get(), SoundSource.PLAYERS, 0.3f, 1.0f + (float)a / 10.0f);
                    if (attacker.m_21124_(MobEffects.f_19598_).m_19564_() < maximum_stacks) {
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, a), (Entity)attacker);
                    } else {
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, a - 1), (Entity)attacker);
                    }
                } else {
                    attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 1), (Entity)attacker);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_21023_(MobEffects.f_19598_)) {
            int strength_tier = (int)SimplySwordsConfig.getFloatValue("ferocity_strength_tier");
            int a = user.m_21124_(MobEffects.f_19598_).m_19564_() * 20;
            user.m_147207_(new MobEffectInstance(MobEffects.f_19600_, a, strength_tier), (Entity)user);
            user.m_6674_(hand);
            user.m_21195_(MobEffects.f_19598_);
            world.m_5594_(null, user.m_142538_(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), SoundSource.PLAYERS, 0.5f, 1.5f);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123811_, ParticleTypes.f_123811_, ParticleTypes.f_123811_, false);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.ferocitysworditem.tooltip1").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.ferocitysworditem.tooltip2"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.ferocitysworditem.tooltip3"));
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.onrightclick").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.ferocitysworditem.tooltip4"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.ferocitysworditem.tooltip5"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.ferocitysworditem.tooltip6"));
    }
}

