/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class GravSwordItem
extends SwordItem {
    public GravSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int fhitchance = (int)SimplySwordsConfig.getFloatValue("gravity_chance");
        int fduration = (int)SimplySwordsConfig.getFloatValue("gravity_duration");
        int hradius = (int)SimplySwordsConfig.getFloatValue("gravity_radius");
        int vradius = (int)(SimplySwordsConfig.getFloatValue("gravity_radius") / 2.0f);
        attacker.m_20256_(attacker.m_20154_().m_82490_(1.0));
        attacker.f_19864_ = true;
        if (attacker.m_21187_().nextInt(100) <= fhitchance) {
            attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 5), (Entity)attacker);
        }
        target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 40, 3), (Entity)attacker);
        if (!attacker.f_19853_.m_5776_()) {
            double x = attacker.m_20185_();
            double y = attacker.m_20186_();
            double z = attacker.m_20189_();
            ServerLevel sworld = (ServerLevel)attacker.f_19853_;
            AABB box = new AABB(x + (double)hradius, y + (double)vradius, z + (double)hradius, x - (double)hradius, y - (double)vradius, z - (double)hradius);
            for (Entity ee : sworld.m_6249_((Entity)attacker, box, EntitySelector.f_20403_)) {
                if (ee == null || !(ee instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)ee;
                if (attacker.m_21023_(MobEffects.f_19598_) && le.m_20270_((Entity)attacker) > 3.0f) {
                    le.m_20256_(le.m_20154_().m_82490_(0.3));
                    sworld.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.SWING_OMEN_ONE.get(), SoundSource.BLOCKS, 0.1f, 2.0f);
                }
                if (!attacker.m_21023_(MobEffects.f_19598_) || !(le.m_20270_((Entity)attacker) <= 3.0f)) continue;
                le.m_20256_(le.m_20154_().m_82490_(-0.1));
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        return super.m_7203_(world, user, hand);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.rendsworditem.tooltip1").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.rendsworditem.tooltip2"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.onrightclick").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.rendsworditem.tooltip3"));
    }
}

