/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EmberIreSwordItem
extends SwordItem {
    private static int stepMod = 0;
    private static SimpleParticleType particleWalk = ParticleTypes.f_123801_;
    private static SimpleParticleType particleSprint = ParticleTypes.f_123801_;
    private static SimpleParticleType particlePassive = ParticleTypes.f_123762_;

    public EmberIreSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.f_19853_.m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.f_19853_;
            int fhitchance = (int)SimplySwordsConfig.getFloatValue("ember_ire_chance");
            int fduration = (int)SimplySwordsConfig.getFloatValue("ember_ire_duration");
            boolean impactsounds_enabled = SimplySwordsConfig.getBooleanValue("enable_weapon_impact_sounds");
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
                if (choose_sound <= 40 && choose_sound > 30) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), SoundSource.PLAYERS, 0.5f, 1.1f + choose_pitch);
                }
            }
            if (attacker.m_21187_().nextInt(100) <= fhitchance) {
                attacker.m_20254_(fduration / 20);
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19600_, fduration, 0), (Entity)attacker);
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, fduration, 1), (Entity)attacker);
                attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 0), (Entity)attacker);
                world.m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_01.get(), SoundSource.PLAYERS, 0.5f, 2.0f);
                particlePassive = ParticleTypes.f_123756_;
                particleWalk = ParticleTypes.f_123777_;
                particleSprint = ParticleTypes.f_123777_;
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.f_19853_.m_5776_() && user.m_21023_(MobEffects.f_19600_) && user.m_21023_(MobEffects.f_19598_) && user.m_21023_(MobEffects.f_19596_)) {
            ServerLevel sWorld = (ServerLevel)user.f_19853_;
            BlockPos position = user.m_142538_();
            Vec3 rotation = user.m_20252_(1.0f);
            Vec3 newPos = user.m_20182_().m_82549_(rotation);
            LargeFireball fireball = new LargeFireball(EntityType.f_20463_, world);
            fireball.m_20248_(newPos.m_7096_(), user.m_20186_() + 1.5, newPos.m_7094_());
            fireball.m_5602_((Entity)user);
            user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 20, 4), (Entity)user);
            user.m_147207_(new MobEffectInstance(MobEffects.f_19607_, 60, 2), (Entity)user);
            sWorld.m_7967_((Entity)fireball);
            fireball.m_20256_(rotation);
            user.m_21195_(MobEffects.f_19600_);
            user.m_21195_(MobEffects.f_19596_);
            user.m_21195_(MobEffects.f_19598_);
            world.m_5594_(null, position, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), SoundSource.PLAYERS, 0.3f, 2.0f);
            user.m_20095_();
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_21023_(MobEffects.f_19600_) && !player.m_6060_()) {
            particlePassive = ParticleTypes.f_123762_;
            particleWalk = ParticleTypes.f_123801_;
            particleSprint = ParticleTypes.f_123801_;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, particleWalk, particleSprint, particlePassive, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.emberiresworditem.tooltip1").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.emberiresworditem.tooltip2"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.emberiresworditem.tooltip3"));
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.onrightclick").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.emberiresworditem.tooltip4"));
        tooltip.add((Component)new TranslatableComponent("item.simplyswords.emberiresworditem.tooltip5"));
    }
}

