/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sweenus.simplyswords.config.Config;

public class SimplySwordsConfig {
    private static final HashMap<String, Boolean> BOOLEAN_OPTIONS = new LinkedHashMap<String, Boolean>();
    private static final HashMap<String, Float> GENERAL_OPTIONS = new LinkedHashMap<String, Float>();
    private static final HashMap<String, Float> FLOAT_OPTIONS = new LinkedHashMap<String, Float>();
    private static final HashMap<String, Float> WEAPON_OPTIONS = new LinkedHashMap<String, Float>();

    public static boolean getBooleanValue(String key) {
        if (!BOOLEAN_OPTIONS.containsKey(key)) {
            System.out.println(key);
        }
        return BOOLEAN_OPTIONS.getOrDefault(key, null);
    }

    public static float getGeneralSettings(String key) {
        if (!GENERAL_OPTIONS.containsKey(key)) {
            System.out.println(key);
        }
        return ((Float)GENERAL_OPTIONS.getOrDefault(key, null)).floatValue();
    }

    public static float getFloatValue(String key) {
        if (!FLOAT_OPTIONS.containsKey(key)) {
            System.out.println(key);
        }
        return ((Float)FLOAT_OPTIONS.getOrDefault(key, null)).floatValue();
    }

    public static float getWeaponAttributes(String key) {
        if (!WEAPON_OPTIONS.containsKey(key)) {
            System.out.println(key);
        }
        return WEAPON_OPTIONS.get(key).floatValue();
    }

    public static void init() {
        FLOAT_OPTIONS.put("speed_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("speed_duration", Float.valueOf(300.0f));
        FLOAT_OPTIONS.put("slowness_chance", Float.valueOf(50.0f));
        FLOAT_OPTIONS.put("slowness_duration", Float.valueOf(50.0f));
        FLOAT_OPTIONS.put("toxin_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("toxin_duration", Float.valueOf(150.0f));
        FLOAT_OPTIONS.put("freeze_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("freeze_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("wildfire_chance", Float.valueOf(10.0f));
        FLOAT_OPTIONS.put("wildfire_duration", Float.valueOf(180.0f));
        FLOAT_OPTIONS.put("wildfire_radius", Float.valueOf(10.0f));
        FLOAT_OPTIONS.put("levitation_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("levitation_duration", Float.valueOf(50.0f));
        FLOAT_OPTIONS.put("zephyr_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("zephyr_duration", Float.valueOf(180.0f));
        FLOAT_OPTIONS.put("shielding_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("shielding_duration", Float.valueOf(60.0f));
        FLOAT_OPTIONS.put("stoneskin_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("stoneskin_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("trailblaze_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("trailblaze_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("weaken_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("weaken_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("unstable_frequency", Float.valueOf(140.0f));
        FLOAT_OPTIONS.put("unstable_duration", Float.valueOf(140.0f));
        FLOAT_OPTIONS.put("active_defence_frequency", Float.valueOf(20.0f));
        FLOAT_OPTIONS.put("active_defence_radius", Float.valueOf(5.0f));
        FLOAT_OPTIONS.put("frostward_frequency", Float.valueOf(20.0f));
        FLOAT_OPTIONS.put("frostward_radius", Float.valueOf(5.0f));
        FLOAT_OPTIONS.put("frostward_slow_duration", Float.valueOf(60.0f));
        FLOAT_OPTIONS.put("watcher_chance", Float.valueOf(5.0f));
        FLOAT_OPTIONS.put("watcher_restore_amount", Float.valueOf(0.5f));
        FLOAT_OPTIONS.put("watcher_radius", Float.valueOf(8.0f));
        FLOAT_OPTIONS.put("omen_chance", Float.valueOf(75.0f));
        FLOAT_OPTIONS.put("omen_absorption_amount", Float.valueOf(1.0f));
        FLOAT_OPTIONS.put("omen_instantkill_threshold", Float.valueOf(0.25f));
        FLOAT_OPTIONS.put("steal_chance", Float.valueOf(25.0f));
        FLOAT_OPTIONS.put("steal_duration", Float.valueOf(400.0f));
        FLOAT_OPTIONS.put("steal_invis_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("steal_blind_duration", Float.valueOf(200.0f));
        FLOAT_OPTIONS.put("steal_radius", Float.valueOf(30.0f));
        FLOAT_OPTIONS.put("gravity_chance", Float.valueOf(35.0f));
        FLOAT_OPTIONS.put("gravity_duration", Float.valueOf(250.0f));
        FLOAT_OPTIONS.put("gravity_radius", Float.valueOf(10.0f));
        FLOAT_OPTIONS.put("soulmeld_chance", Float.valueOf(75.0f));
        FLOAT_OPTIONS.put("soulmeld_duration", Float.valueOf(250.0f));
        FLOAT_OPTIONS.put("soulmeld_radius", Float.valueOf(5.0f));
        FLOAT_OPTIONS.put("soulrend_chance", Float.valueOf(85.0f));
        FLOAT_OPTIONS.put("soulrend_duration", Float.valueOf(500.0f));
        FLOAT_OPTIONS.put("soulrend_rend_damage_multiplier", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("soulrend_rend_heal_multiplier", Float.valueOf(0.5f));
        FLOAT_OPTIONS.put("soulrend_radius", Float.valueOf(10.0f));
        FLOAT_OPTIONS.put("soulrend_max_stacks", Float.valueOf(8.0f));
        FLOAT_OPTIONS.put("ferocity_chance", Float.valueOf(75.0f));
        FLOAT_OPTIONS.put("ferocity_duration", Float.valueOf(100.0f));
        FLOAT_OPTIONS.put("ferocity_max_stacks", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("ferocity_strength_tier", Float.valueOf(2.0f));
        FLOAT_OPTIONS.put("ember_ire_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("ember_ire_duration", Float.valueOf(150.0f));
        FLOAT_OPTIONS.put("volcanic_fury_chance", Float.valueOf(25.0f));
        FLOAT_OPTIONS.put("volcanic_fury_radius", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("volcanic_fury_cooldown", Float.valueOf(300.0f));
        FLOAT_OPTIONS.put("volcanic_fury_damage", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("storm_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("storm_radius", Float.valueOf(10.0f));
        FLOAT_OPTIONS.put("plague_chance", Float.valueOf(55.0f));
        FLOAT_OPTIONS.put("brimstone_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("bramble_chance", Float.valueOf(45.0f));
        FLOAT_OPTIONS.put("bramble_radius", Float.valueOf(10.0f));
        FLOAT_OPTIONS.put("soultether_range", Float.valueOf(32.0f));
        FLOAT_OPTIONS.put("soultether_radius", Float.valueOf(8.0f));
        FLOAT_OPTIONS.put("soultether_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("soultether_ignite_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("soultether_resistance_duration", Float.valueOf(60.0f));
        FLOAT_OPTIONS.put("frostfury_cooldown", Float.valueOf(380.0f));
        FLOAT_OPTIONS.put("frostfury_radius", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("frostfury_damage", Float.valueOf(18.0f));
        FLOAT_OPTIONS.put("frostfury_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("frostfury_duration", Float.valueOf(80.0f));
        FLOAT_OPTIONS.put("moltenroar_cooldown", Float.valueOf(320.0f));
        FLOAT_OPTIONS.put("moltenroar_radius", Float.valueOf(5.0f));
        FLOAT_OPTIONS.put("moltenroar_knockback_strength", Float.valueOf(5.0f));
        FLOAT_OPTIONS.put("moltenroar_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("moltenroar_duration", Float.valueOf(100.0f));
        FLOAT_OPTIONS.put("frostshatter_radius", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("frostshatter_damage", Float.valueOf(18.0f));
        FLOAT_OPTIONS.put("frostshatter_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("frostshatter_duration", Float.valueOf(80.0f));
        FLOAT_OPTIONS.put("permafrost_radius", Float.valueOf(4.0f));
        FLOAT_OPTIONS.put("permafrost_damage", Float.valueOf(1.0f));
        FLOAT_OPTIONS.put("permafrost_cooldown", Float.valueOf(600.0f));
        FLOAT_OPTIONS.put("permafrost_duration", Float.valueOf(200.0f));
        FLOAT_OPTIONS.put("arcaneassault_radius", Float.valueOf(6.0f));
        FLOAT_OPTIONS.put("arcaneassault_damage", Float.valueOf(1.0f));
        FLOAT_OPTIONS.put("arcaneassault_cooldown", Float.valueOf(220.0f));
        FLOAT_OPTIONS.put("arcaneassault_chance", Float.valueOf(25.0f));
        FLOAT_OPTIONS.put("arcaneassault_duration", Float.valueOf(120.0f));
        FLOAT_OPTIONS.put("thunderblitz_radius", Float.valueOf(2.0f));
        FLOAT_OPTIONS.put("thunderblitz_damage", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("thunderblitz_cooldown", Float.valueOf(250.0f));
        FLOAT_OPTIONS.put("thunderblitz_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("stormjolt_cooldown", Float.valueOf(100.0f));
        FLOAT_OPTIONS.put("stormjolt_chance", Float.valueOf(15.0f));
        FLOAT_OPTIONS.put("soulanguish_radius", Float.valueOf(3.0f));
        FLOAT_OPTIONS.put("soulanguish_damage", Float.valueOf(1.0f));
        FLOAT_OPTIONS.put("soulanguish_cooldown", Float.valueOf(700.0f));
        FLOAT_OPTIONS.put("soulanguish_duration", Float.valueOf(500.0f));
        FLOAT_OPTIONS.put("soulanguish_heal", Float.valueOf(0.5f));
        FLOAT_OPTIONS.put("soulanguish_range", Float.valueOf(22.0f));
        FLOAT_OPTIONS.put("shockdeflect_block_duration", Float.valueOf(35.0f));
        FLOAT_OPTIONS.put("shockdeflect_damage", Float.valueOf(12.0f));
        FLOAT_OPTIONS.put("shockdeflect_cooldown", Float.valueOf(90.0f));
        FLOAT_OPTIONS.put("shockdeflect_parry_duration", Float.valueOf(10.0f));
        GENERAL_OPTIONS.put("standard_loot_table_weight", Float.valueOf(0.08f));
        GENERAL_OPTIONS.put("rare_loot_table_weight", Float.valueOf(0.01f));
        GENERAL_OPTIONS.put("unique_loot_table_weight", Float.valueOf(0.008f));
        BOOLEAN_OPTIONS.put("display_config_outdated_warning", true);
        BOOLEAN_OPTIONS.put("add_weapons_to_loot_tables", true);
        BOOLEAN_OPTIONS.put("loot_can_be_found_in_villages", true);
        BOOLEAN_OPTIONS.put("enable_weapon_impact_sounds", true);
        BOOLEAN_OPTIONS.put("enable_weapon_footfalls", true);
        BOOLEAN_OPTIONS.put("enable_passive_particles", true);
        BOOLEAN_OPTIONS.put("compat_gobber_end_weapons_unbreakable", true);
        WEAPON_OPTIONS.put("longsword_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("twinblade_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("rapier_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("katana_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("sai_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("spear_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("glaive_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("warglaive_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("cutlass_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("claymore_positive_damage_modifier", Float.valueOf(2.0f));
        WEAPON_OPTIONS.put("greataxe_positive_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("greathammer_positive_damage_modifier", Float.valueOf(4.0f));
        WEAPON_OPTIONS.put("chakram_positive_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("scythe_positive_damage_modifier", Float.valueOf(1.0f));
        WEAPON_OPTIONS.put("longsword_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("twinblade_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("rapier_negative_damage_modifier", Float.valueOf(1.0f));
        WEAPON_OPTIONS.put("katana_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("sai_negative_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("spear_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("glaive_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("warglaive_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("cutlass_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("claymore_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("greataxe_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("greathammer_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("chakram_negative_damage_modifier", Float.valueOf(1.0f));
        WEAPON_OPTIONS.put("scythe_negative_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("iron_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("gold_damage_modifier", Float.valueOf(2.0f));
        WEAPON_OPTIONS.put("diamond_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("netherite_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("runic_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("longsword_attackspeed", Float.valueOf(-2.4f));
        WEAPON_OPTIONS.put("twinblade_attackspeed", Float.valueOf(-2.0f));
        WEAPON_OPTIONS.put("rapier_attackspeed", Float.valueOf(-1.8f));
        WEAPON_OPTIONS.put("katana_attackspeed", Float.valueOf(-2.0f));
        WEAPON_OPTIONS.put("sai_attackspeed", Float.valueOf(-1.5f));
        WEAPON_OPTIONS.put("spear_attackspeed", Float.valueOf(-2.7f));
        WEAPON_OPTIONS.put("glaive_attackspeed", Float.valueOf(-2.6f));
        WEAPON_OPTIONS.put("warglaive_attackspeed", Float.valueOf(-2.2f));
        WEAPON_OPTIONS.put("cutlass_attackspeed", Float.valueOf(-2.0f));
        WEAPON_OPTIONS.put("claymore_attackspeed", Float.valueOf(-2.8f));
        WEAPON_OPTIONS.put("greataxe_attackspeed", Float.valueOf(-3.1f));
        WEAPON_OPTIONS.put("greathammer_attackspeed", Float.valueOf(-3.2f));
        WEAPON_OPTIONS.put("chakram_attackspeed", Float.valueOf(-3.0f));
        WEAPON_OPTIONS.put("scythe_attackspeed", Float.valueOf(-2.7f));
        WEAPON_OPTIONS.put("brimstone_damage_modifier", Float.valueOf(6.0f));
        WEAPON_OPTIONS.put("thewatcher_damage_modifier", Float.valueOf(6.0f));
        WEAPON_OPTIONS.put("stormsedge_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("stormbringer_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("swordonastick_damage_modifier", Float.valueOf(5.0f));
        WEAPON_OPTIONS.put("bramblethorn_damage_modifier", Float.valueOf(6.0f));
        WEAPON_OPTIONS.put("watchingwarglaive_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("longswordofplague_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("emberblade_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("hearthflame_damage_modifier", Float.valueOf(8.0f));
        WEAPON_OPTIONS.put("soulkeeper_damage_modifier", Float.valueOf(8.0f));
        WEAPON_OPTIONS.put("twistedblade_damage_modifier", Float.valueOf(4.0f));
        WEAPON_OPTIONS.put("soulstealer_damage_modifier", Float.valueOf(0.0f));
        WEAPON_OPTIONS.put("soulrender_damage_modifier", Float.valueOf(4.0f));
        WEAPON_OPTIONS.put("mjolnir_damage_modifier", Float.valueOf(3.0f));
        WEAPON_OPTIONS.put("thedispatcher_damage_modifier", Float.valueOf(4.0f));
        WEAPON_OPTIONS.put("soulpyre_damage_modifier", Float.valueOf(7.0f));
        WEAPON_OPTIONS.put("frostfall_damage_modifier", Float.valueOf(5.0f));
        WEAPON_OPTIONS.put("moltenedge_damage_modifier", Float.valueOf(4.0f));
        WEAPON_OPTIONS.put("livyatan_damage_modifier", Float.valueOf(4.0f));
        WEAPON_OPTIONS.put("icewhisper_damage_modifier", Float.valueOf(7.0f));
        WEAPON_OPTIONS.put("arcanethyst_damage_modifier", Float.valueOf(7.0f));
        WEAPON_OPTIONS.put("thunderbrand_damage_modifier", Float.valueOf(7.0f));
        WEAPON_OPTIONS.put("lichblade_damage_modifier", Float.valueOf(7.0f));
        WEAPON_OPTIONS.put("brimstone_attackspeed", Float.valueOf(-2.8f));
        WEAPON_OPTIONS.put("thewatcher_attackspeed", Float.valueOf(-2.8f));
        WEAPON_OPTIONS.put("stormsedge_attackspeed", Float.valueOf(-2.0f));
        WEAPON_OPTIONS.put("stormbringer_attackspeed", Float.valueOf(-2.4f));
        WEAPON_OPTIONS.put("swordonastick_attackspeed", Float.valueOf(-2.6f));
        WEAPON_OPTIONS.put("bramblethorn_attackspeed", Float.valueOf(-1.8f));
        WEAPON_OPTIONS.put("watchingwarglaive_attackspeed", Float.valueOf(-2.2f));
        WEAPON_OPTIONS.put("longswordofplague_attackspeed", Float.valueOf(-2.4f));
        WEAPON_OPTIONS.put("emberblade_attackspeed", Float.valueOf(-2.4f));
        WEAPON_OPTIONS.put("hearthflame_attackspeed", Float.valueOf(-3.2f));
        WEAPON_OPTIONS.put("soulkeeper_attackspeed", Float.valueOf(-2.9f));
        WEAPON_OPTIONS.put("twistedblade_attackspeed", Float.valueOf(-2.6f));
        WEAPON_OPTIONS.put("soulstealer_attackspeed", Float.valueOf(-1.5f));
        WEAPON_OPTIONS.put("soulrender_attackspeed", Float.valueOf(-2.4f));
        WEAPON_OPTIONS.put("mjolnir_attackspeed", Float.valueOf(-3.0f));
        WEAPON_OPTIONS.put("thedispatcher_attackspeed", Float.valueOf(-2.0f));
        WEAPON_OPTIONS.put("soulpyre_attackspeed", Float.valueOf(-3.0f));
        WEAPON_OPTIONS.put("frostfall_attackspeed", Float.valueOf(-2.5f));
        WEAPON_OPTIONS.put("moltenedge_attackspeed", Float.valueOf(-2.1f));
        WEAPON_OPTIONS.put("livyatan_attackspeed", Float.valueOf(-2.1f));
        WEAPON_OPTIONS.put("icewhisper_attackspeed", Float.valueOf(-3.1f));
        WEAPON_OPTIONS.put("arcanethyst_attackspeed", Float.valueOf(-3.1f));
        WEAPON_OPTIONS.put("thunderbrand_attackspeed", Float.valueOf(-3.1f));
        WEAPON_OPTIONS.put("lichblade_attackspeed", Float.valueOf(-3.1f));
    }

    public static void loadConfig() {
        JsonObject json = Config.getJsonObject(Config.readFile(new File("config/simplyswords/booleans.json5")));
        for (Map.Entry entry : json.entrySet()) {
            BOOLEAN_OPTIONS.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
        }
        json = Config.getJsonObject(Config.readFile(new File("config/simplyswords/general_config.json5")));
        for (Map.Entry entry : json.entrySet()) {
            GENERAL_OPTIONS.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
        }
        json = Config.getJsonObject(Config.readFile(new File("config/simplyswords/effects_config.json5")));
        for (Map.Entry entry : json.entrySet()) {
            FLOAT_OPTIONS.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
        }
        json = Config.getJsonObject(Config.readFile(new File("config/simplyswords/weapon_attributes.json5")));
        for (Map.Entry entry : json.entrySet()) {
            WEAPON_OPTIONS.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
        }
    }

    public static void generateConfigs(boolean overwrite) {
        StringBuilder config = new StringBuilder("{\n");
        int i = 0;
        for (String key : BOOLEAN_OPTIONS.keySet()) {
            config.append("  \"").append(key).append("\": ").append(BOOLEAN_OPTIONS.get(key));
            if (++i < BOOLEAN_OPTIONS.size()) {
                config.append(",");
            }
            config.append("\n");
        }
        config.append("}");
        Config.createFile("config/simplyswords/booleans.json5", config.toString(), overwrite);
        config = new StringBuilder("{\n");
        i = 0;
        for (String item : GENERAL_OPTIONS.keySet()) {
            if (i == 0) {
                config.append("// -- GENERAL CONFIGURATION -- \n");
                config.append("\n");
                config.append("// -- Loot Table Weights -- \n");
                config.append("// The chances of loot appearing in chests. \n");
                config.append("// 1 = 100% chance \n");
                config.append("// Values are very sensitive - recommend keeping changes small \n");
                config.append("// Simply Swords loot has a chance to appear in any chest vanilla or modded, except villager chests \n");
                config.append("// ------------------------ \n");
                config.append("\n");
                config.append("// Standard Loot: Iron > Gold Weapons. Default: 0.08 \n");
            }
            if (i == 1) {
                config.append("\n");
                config.append("// Rare Loot: Diamond & Runic Weapons. Default: 0.008 \n");
            }
            if (i == 2) {
                config.append("\n");
                config.append("// Unique Loot: Unique Weapons. Default: 0.002 \n");
            }
            config.append("  \"").append(item).append("\": ").append(GENERAL_OPTIONS.get(item));
            if (++i < GENERAL_OPTIONS.size()) {
                config.append(",");
            }
            config.append("\n");
        }
        config.append("}");
        Config.createFile("config/simplyswords/general_config.json5", config.toString(), overwrite);
        config = new StringBuilder("{\n");
        i = 0;
        for (String item : FLOAT_OPTIONS.keySet()) {
            if (i == 0) {
                config.append("// -- EFFECTS CONFIGURATION -- \n");
                config.append("\n");
                config.append("//Chance range 0-100, where 100 = 100% chance to occur\n");
                config.append("//Radius is measured in blocks\n");
                config.append("//Duration in ticks, where 20 is equivalent to one second \n");
                config.append("\n");
                config.append("// ---------------------------- \n");
                config.append("// -- Runic Power: Swiftness -- \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 2) {
                config.append("\n");
                config.append("// ----------------------- \n");
                config.append("// -- Runic Power: Slow -- \n");
                config.append("// ----------------------- \n");
            }
            if (i == 4) {
                config.append("\n");
                config.append("// ------------------------- \n");
                config.append("// -- Runic Power: Poison -- \n");
                config.append("// ------------------------- \n");
            }
            if (i == 6) {
                config.append("\n");
                config.append("// ------------------------- \n");
                config.append("// -- Runic Power: Freeze -- \n");
                config.append("// ------------------------- \n");
            }
            if (i == 8) {
                config.append("\n");
                config.append("// --------------------------- \n");
                config.append("// -- Runic Power: Wildfire -- \n");
                config.append("// --------------------------- \n");
            }
            if (i == 11) {
                config.append("\n");
                config.append("// ------------------------ \n");
                config.append("// -- Runic Power: Float -- \n");
                config.append("// ------------------------ \n");
            }
            if (i == 13) {
                config.append("\n");
                config.append("// ------------------------- \n");
                config.append("// -- Runic Power: Zephyr -- \n");
                config.append("// ------------------------- \n");
            }
            if (i == 15) {
                config.append("\n");
                config.append("// ---------------------------- \n");
                config.append("// -- Runic Power: Shielding -- \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 17) {
                config.append("\n");
                config.append("// ---------------------------- \n");
                config.append("// -- Runic Power: Stoneskin -- \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 19) {
                config.append("\n");
                config.append("// ----------------------------- \n");
                config.append("// -- Runic Power: Trailblaze -- \n");
                config.append("// ----------------------------- \n");
            }
            if (i == 21) {
                config.append("\n");
                config.append("// ------------------------- \n");
                config.append("// -- Runic Power: Weaken -- \n");
                config.append("// ------------------------- \n");
            }
            if (i == 23) {
                config.append("\n");
                config.append("// --------------------------- \n");
                config.append("// -- Runic Power: Unstable -- \n");
                config.append("// --------------------------- \n");
            }
            if (i == 25) {
                config.append("\n");
                config.append("// --------------------------------- \n");
                config.append("// -- Runic Power: Active Defence -- \n");
                config.append("// --------------------------------- \n");
            }
            if (i == 27) {
                config.append("\n");
                config.append("// ----------------------------- \n");
                config.append("// -- Runic Power: Frost Ward -- \n");
                config.append("// ----------------------------- \n");
            }
            if (i == 30) {
                config.append("\n");
                config.append("// ---------------------------- \n");
                config.append("// -- Unique Effect: Watcher -- \n");
                config.append("// -- Restore amount refers to health gained from each enemy in range -- \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 33) {
                config.append("\n");
                config.append("// ------------------------- \n");
                config.append("// -- Unique Effect: Omen -- \n");
                config.append("// -- Absorption amount refers to the tier of regeneration gained on proc -- \n");
                config.append("// -- Instantkill Threshold refers to the % of maxhealth an enemy must be UNDER in order for the effect to proc. Where 1 = 100% -- \n");
                config.append("// ------------------------- \n");
            }
            if (i == 36) {
                config.append("\n");
                config.append("// ------------------------------- \n");
                config.append("// -- Unique Effect: Soul Steal -- \n");
                config.append("// Duration refers to the haste, slow, and glow effects \n");
                config.append("// ------------------------------- \n");
            }
            if (i == 41) {
                config.append("\n");
                config.append("// ---------------------------- \n");
                config.append("// -- Unique Effect: Gravity -- \n");
                config.append("// NOT YET IMPLEMENTED \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 44) {
                config.append("\n");
                config.append("// ------------------------------ \n");
                config.append("// -- Unique Effect: Soul Meld -- \n");
                config.append("// ------------------------------ \n");
            }
            if (i == 47) {
                config.append("\n");
                config.append("// ------------------------------ \n");
                config.append("// -- Unique Effect: Soul Rend -- \n");
                config.append("// ------------------------------ \n");
            }
            if (i == 53) {
                config.append("\n");
                config.append("// ----------------------------- \n");
                config.append("// -- Unique Effect: Ferocity -- \n");
                config.append("// ----------------------------- \n");
            }
            if (i == 57) {
                config.append("\n");
                config.append("// ------------------------------ \n");
                config.append("// -- Unique Effect: Ember Ire -- \n");
                config.append("// ------------------------------ \n");
            }
            if (i == 59) {
                config.append("\n");
                config.append("// ---------------------------------- \n");
                config.append("// -- Unique Effect: Volcanic Fury -- \n");
                config.append("// ---------------------------------- \n");
            }
            if (i == 63) {
                config.append("\n");
                config.append("// -------------------------- \n");
                config.append("// -- Unique Effect: Storm -- \n");
                config.append("// -------------------------- \n");
            }
            if (i == 65) {
                config.append("\n");
                config.append("// --------------------------- \n");
                config.append("// -- Unique Effect: Plague -- \n");
                config.append("// --------------------------- \n");
            }
            if (i == 66) {
                config.append("\n");
                config.append("// ------------------------------ \n");
                config.append("// -- Unique Effect: Brimstone -- \n");
                config.append("// ------------------------------ \n");
            }
            if (i == 67) {
                config.append("\n");
                config.append("// ---------------------------- \n");
                config.append("// -- Unique Effect: Bramble -- \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 69) {
                config.append("\n");
                config.append("// -------------------------------- \n");
                config.append("// -- Unique Effect: Soul Tether -- \n");
                config.append("// -------------------------------- \n");
            }
            if (i == 74) {
                config.append("\n");
                config.append("// ------------------------------- \n");
                config.append("// -- Unique Effect: Frost Fury -- \n");
                config.append("// ------------------------------- \n");
            }
            if (i == 79) {
                config.append("\n");
                config.append("// -------------------------------- \n");
                config.append("// -- Unique Effect: Molten Roar -- \n");
                config.append("// -------------------------------- \n");
            }
            if (i == 84) {
                config.append("\n");
                config.append("// ---------------------------------- \n");
                config.append("// -- Unique Effect: Frost Shatter -- \n");
                config.append("// ---------------------------------- \n");
            }
            if (i == 88) {
                config.append("\n");
                config.append("// ------------------------------- \n");
                config.append("// -- Unique Effect: Permafrost -- \n");
                config.append("// ------------------------------- \n");
            }
            if (i == 92) {
                config.append("\n");
                config.append("// ----------------------------------- \n");
                config.append("// -- Unique Effect: Arcane Assault -- \n");
                config.append("// ----------------------------------- \n");
            }
            if (i == 97) {
                config.append("\n");
                config.append("// ---------------------------------- \n");
                config.append("// -- Unique Effect: Thunder Blitz -- \n");
                config.append("// ---------------------------------- \n");
            }
            if (i == 101) {
                config.append("\n");
                config.append("// ------------------------------- \n");
                config.append("// -- Unique Effect: Storm Jolt -- \n");
                config.append("// ------------------------------- \n");
            }
            if (i == 103) {
                config.append("\n");
                config.append("// --------------------------------- \n");
                config.append("// -- Unique Effect: Soul Anguish -- \n");
                config.append("// --------------------------------- \n");
            }
            if (i == 109) {
                config.append("\n");
                config.append("// ---------------------------------- \n");
                config.append("// -- Unique Effect: Shock Deflect -- \n");
                config.append("// ---------------------------------- \n");
            }
            config.append("  \"").append(item).append("\": ").append(FLOAT_OPTIONS.get(item));
            if (++i < FLOAT_OPTIONS.size()) {
                config.append(",");
            }
            config.append("\n");
        }
        config.append("}");
        Config.createFile("config/simplyswords/effects_config.json5", config.toString(), overwrite);
        config = new StringBuilder("{\n");
        i = 0;
        for (String item : WEAPON_OPTIONS.keySet()) {
            if (i == 0) {
                config.append("// -- WEAPON ATTRIBUTES CONFIGURATION -- \n");
                config.append("// These values should be THE SAME ON BOTH CLIENT AND SERVER, otherwise damage tooltips will display incorrect on the client \n");
                config.append("// The damage values of weapons can be modified by adjusting their weights \n");
                config.append("// This is not the outputted damage value you see in game, but it affects it directly \n");
                config.append("// Calculation: vanilla tool material damage + base_modifier + positive_modifier - negative_modifier = actual modifier \n");
                config.append("\n");
                config.append("// -- Positive Damage Modifiers -- \n");
                config.append("// Example use-case: Adding 3 to a value below will INCREASE the in-game damage of that weapon type by 3 \n");
                config.append("// ------------------------------- \n");
            }
            if (i == 14) {
                config.append("\n");
                config.append("// -- Negative Damage Modifiers -- \n");
                config.append("// Example use-case: Adding 3 to a value below will DECREASE the in-game damage of that weapon type by 3 \n");
                config.append("// ------------------------------- \n");
            }
            if (i == 28) {
                config.append("\n");
                config.append("// -- Base Damage Modifiers -- \n");
                config.append("// Positive & Negative damage modifiers scale off these base values \n");
                config.append("// --------------------------- \n");
            }
            if (i == 33) {
                config.append("\n");
                config.append("// -- Attack Speed Modifiers -- \n");
                config.append("// Recommended range: -1.0 to -3.7, with -1.0 being fast and -3.7 being slow \n");
                config.append("// ---------------------------- \n");
            }
            if (i == 47) {
                config.append("\n");
                config.append("\n");
                config.append("// -- UNIQUE ATTRIBUTES CONFIGURATION -- \n");
                config.append("// Uniques scale a little bit differently and only require one modifier \n");
                config.append("// This is not the outputted damage value you see in game, but it affects it directly \n");
                config.append("// Calculation: Vanilla netherite tool damage + damage_modifier = actual modifier \n");
                config.append("\n");
                config.append("// -- Damage Modifiers -- \n");
                config.append("// Example use-case: Adding 3 to a value below will INCREASE the in-game damage of that weapon by 3 \n");
                config.append("// ---------------------- \n");
            }
            if (i == 71) {
                config.append("\n");
                config.append("// -- Attack Speed Modifiers -- \n");
                config.append("// Recommended range: -1.0 to -3.7, with -1.0 being fast and -3.7 being slow \n");
                config.append("// ---------------------------- \n");
            }
            config.append("  \"").append(item).append("\": ").append(WEAPON_OPTIONS.get(item));
            if (++i < WEAPON_OPTIONS.size()) {
                config.append(",");
            }
            config.append("\n");
        }
        config.append("}");
        Config.createFile("config/simplyswords/weapon_attributes.json5", config.toString(), overwrite);
    }
}

