/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterBiome;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class BiomeModuleForge {
    private static final Map<String, DeferredRegister<Biome>> registersByModId = new HashMap<String, DeferredRegister<Biome>>();

    public static void processEntries() {
        AutoRegistrationManager.BIOMES.stream().filter(data -> !data.processed()).forEach(BiomeModuleForge::register);
    }

    private static void register(AutoRegisterField data) {
        String modId = data.name().m_135827_();
        if (!registersByModId.containsKey(modId)) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registry.f_122885_, (String)modId);
            deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
            registersByModId.put(modId, (DeferredRegister<Biome>)deferredRegister);
        }
        AutoRegisterBiome autoRegisterBiome = (AutoRegisterBiome)data.object();
        Supplier biomeSupplier = autoRegisterBiome.getSupplier();
        DeferredRegister<Biome> deferredRegister = registersByModId.get(modId);
        RegistryObject registryObject = deferredRegister.register(data.name().m_135815_(), biomeSupplier);
        autoRegisterBiome.setSupplier(registryObject);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)data.name());
        autoRegisterBiome.setResourceKey((ResourceKey<Biome>)key);
        data.markProcessed();
    }
}

