/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.api.autoregister;

import com.mojang.datafixers.util.Either;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterConfiguredFeature;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterEntry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class AutoRegisterPlacedFeature
extends AutoRegisterEntry<PlacedFeature> {
    private final Either<AutoRegisterConfiguredFeature<?>, Holder<ConfiguredFeature<?, ?>>> innerConfiguredFeature;
    private final List<PlacementModifier> placementModifiers;
    private Holder<PlacedFeature> holder;
    private boolean registered = false;
    public ResourceLocation id = null;

    public static AutoRegisterPlacedFeature of(AutoRegisterConfiguredFeature<?> configuredFeature, List<PlacementModifier> placementModifiers) {
        return new AutoRegisterPlacedFeature(configuredFeature, placementModifiers);
    }

    public static AutoRegisterPlacedFeature of(Holder<ConfiguredFeature<?, ?>> configuredFeatureHolder, List<PlacementModifier> placementModifiers) {
        return new AutoRegisterPlacedFeature(configuredFeatureHolder, placementModifiers);
    }

    private AutoRegisterPlacedFeature(AutoRegisterConfiguredFeature<?> autoRegisterConfiguredFeature, List<PlacementModifier> placementModifiers) {
        super(null);
        this.innerConfiguredFeature = Either.left(autoRegisterConfiguredFeature);
        this.placementModifiers = placementModifiers;
    }

    private AutoRegisterPlacedFeature(Holder<ConfiguredFeature<?, ?>> configuredFeatureHolder, List<PlacementModifier> placementModifiers) {
        super(null);
        this.innerConfiguredFeature = Either.right(configuredFeatureHolder);
        this.placementModifiers = placementModifiers;
    }

    public Holder<PlacedFeature> holder() {
        this.register();
        return this.holder;
    }

    private Holder<ConfiguredFeature<?, ?>> getConfiguredFeatureHolder() {
        return (Holder)this.innerConfiguredFeature.map(AutoRegisterConfiguredFeature::holder, holder -> holder);
    }

    public void register() {
        if (this.registered) {
            return;
        }
        PlacedFeature placedFeature = new PlacedFeature(Holder.m_205706_(this.getConfiguredFeatureHolder()), List.copyOf(this.placementModifiers));
        this.holder = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)this.id, (Object)placedFeature);
        this.setSupplier(() -> placedFeature);
        this.registered = true;
    }
}

