/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.mixins;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomDataHolder;
import net.mehvahdjukaar.selene.map.CustomMapDecoration;
import net.mehvahdjukaar.selene.map.ExpandedMapData;
import net.mehvahdjukaar.selene.map.MapDecorationRegistry;
import net.mehvahdjukaar.selene.map.MapHelper;
import net.mehvahdjukaar.selene.map.markers.GenericMapBlockMarker;
import net.mehvahdjukaar.selene.map.markers.MapBlockMarker;
import net.mehvahdjukaar.selene.map.type.IMapDecorationType;
import net.mehvahdjukaar.selene.network.ClientBoundSyncCustomMapDecorationPacket;
import net.mehvahdjukaar.selene.network.NetworkHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.class})
public abstract class MapDataMixin
extends SavedData
implements ExpandedMapData {
    @Final
    @Shadow
    public int f_77885_;
    @Final
    @Shadow
    public int f_77886_;
    @Final
    @Shadow
    public byte f_77890_;
    @Final
    @Shadow
    Map<String, MapDecoration> f_77894_;
    @Final
    @Shadow
    public ResourceKey<Level> f_77887_;
    @Final
    @Shadow
    public boolean f_77892_;
    @Shadow
    @Final
    private Map<String, MapBanner> f_77897_;
    @Unique
    public Map<String, CustomMapDecoration> customDecorations = Maps.newLinkedHashMap();
    @Unique
    private final Map<String, MapBlockMarker<?>> customMapMarkers = Maps.newHashMap();
    @Unique
    public final Map<ResourceLocation, CustomDataHolder.Instance<?>> customData = new HashMap();

    @Override
    public Map<ResourceLocation, CustomDataHolder.Instance<?>> getCustomData() {
        return this.customData;
    }

    @Override
    public Map<String, CustomMapDecoration> getCustomDecorations() {
        return this.customDecorations;
    }

    @Override
    public Map<String, MapBlockMarker<?>> getCustomMarkers() {
        return this.customMapMarkers;
    }

    @Override
    public int getVanillaDecorationSize() {
        return this.f_77894_.size();
    }

    @Override
    public <D extends CustomMapDecoration> void addCustomDecoration(MapBlockMarker<D> marker) {
        D decoration = marker.createDecorationFromMarker(this.f_77890_, this.f_77885_, this.f_77886_, this.f_77887_, this.f_77892_);
        if (decoration != null) {
            this.customDecorations.put(marker.getMarkerId(), (CustomMapDecoration)decoration);
        }
    }

    @Override
    public MapItemSavedData copy() {
        MapItemSavedData newData = MapItemSavedData.m_164807_((CompoundTag)this.m_7176_(new CompoundTag()));
        newData.m_77762_();
        return newData;
    }

    @Override
    public void resetCustomDecoration() {
        for (String key : this.customMapMarkers.keySet()) {
            this.customDecorations.remove(key);
            this.customMapMarkers.remove(key);
        }
        for (String key : this.f_77897_.keySet()) {
            this.f_77897_.remove(key);
            this.f_77894_.remove(key);
        }
    }

    @Override
    public boolean toggleCustomDecoration(LevelAccessor world, BlockPos pos) {
        if (world.m_5776_()) {
            List<MapBlockMarker<?>> markers = MapDecorationRegistry.getMarkersFromWorld((BlockGetter)world, pos);
            return !markers.isEmpty();
        }
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123343_() + 0.5;
        int i = 1 << this.f_77890_;
        double d2 = (d0 - (double)this.f_77885_) / (double)i;
        double d3 = (d1 - (double)this.f_77886_) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            List<MapBlockMarker<?>> markers = MapDecorationRegistry.getMarkersFromWorld((BlockGetter)world, pos);
            boolean changed = false;
            for (MapBlockMarker<?> marker : markers) {
                if (marker == null) continue;
                String id = marker.getMarkerId();
                if (this.customMapMarkers.containsKey(id) && this.customMapMarkers.get(id).equals(marker)) {
                    this.customMapMarkers.remove(id);
                    this.customDecorations.remove(id);
                } else {
                    this.customMapMarkers.put(id, marker);
                    this.addCustomDecoration(marker);
                }
                changed = true;
            }
            if (changed) {
                this.m_77762_();
                return true;
            }
        }
        return false;
    }

    @Inject(method={"locked"}, at={@At(value="RETURN")})
    public void locked(CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomMarkers().putAll(this.getCustomMarkers());
            expandedMapData.getCustomDecorations().putAll(this.getCustomDecorations());
        }
    }

    @Inject(method={"scaled"}, at={@At(value="RETURN")})
    public void scaled(CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomData().putAll(this.customData);
        }
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="TAIL")})
    public void tickCarriedBy(Player player, ItemStack stack, CallbackInfo ci) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (tag.m_128425_("CustomDecorations", 9)) {
                ListTag listTag = tag.m_128437_("CustomDecorations", 10);
                for (int j = 0; j < listTag.size(); ++j) {
                    CompoundTag com = listTag.m_128728_(j);
                    if (this.f_77894_.containsKey(com.m_128461_("id"))) continue;
                    String name = com.m_128461_("type");
                    IMapDecorationType<? extends CustomMapDecoration, ?> type = MapDecorationRegistry.get(name);
                    if (type != null) {
                        GenericMapBlockMarker<? extends CustomMapDecoration> dummy = new GenericMapBlockMarker<CustomMapDecoration>(type, com.m_128451_("x"), com.m_128451_("z"));
                        this.addCustomDecoration(dummy);
                        continue;
                    }
                    Selene.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
                }
            }
            Integer mapId = MapHelper.getMapId(stack, player, this);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (mapId != null) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientBoundSyncCustomMapDecorationPacket(mapId, this.f_77890_, this.f_77892_, this.customDecorations.values().toArray(new CustomMapDecoration[0]), this.customData.values().toArray(new CustomDataHolder.Instance[0])));
                }
            }
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private static void load(CompoundTag compound, CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (compound.m_128441_("customMarkers") && data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            ListTag listNBT = compound.m_128437_("customMarkers", 10);
            for (int j = 0; j < listNBT.size(); ++j) {
                MapBlockMarker<?> marker = MapDecorationRegistry.readWorldMarker(listNBT.m_128728_(j));
                if (marker == null) continue;
                mapData.getCustomMarkers().put(marker.getMarkerId(), marker);
                mapData.addCustomDecoration(marker);
            }
            Map<ResourceLocation, CustomDataHolder.Instance<?>> customData = mapData.getCustomData();
            customData.clear();
            MapDecorationRegistry.CUSTOM_MAP_DATA_TYPES.forEach((s, o) -> {
                CustomDataHolder.Instance i = o.create(compound);
                if (i != null) {
                    customData.put((ResourceLocation)s, i);
                }
            });
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void save(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag com = (CompoundTag)cir.getReturnValue();
        ListTag listNBT = new ListTag();
        for (MapBlockMarker<?> marker : this.customMapMarkers.values()) {
            CompoundTag com2 = new CompoundTag();
            com2.m_128365_(marker.getTypeId(), (Tag)marker.saveToNBT(new CompoundTag()));
            listNBT.add((Object)com2);
        }
        com.m_128365_("customMarkers", (Tag)listNBT);
        this.customData.forEach((s, o) -> o.save(tag));
    }

    @Inject(method={"checkBanners"}, at={@At(value="TAIL")})
    public void checkBanners(BlockGetter world, int x, int z, CallbackInfo ci) {
        Iterator<MapBlockMarker<?>> iterator = this.customMapMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapBlockMarker<?> marker = iterator.next();
            if (marker.getPos().m_123341_() != x || marker.getPos().m_123343_() != z) continue;
            Object newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
            String id = marker.getMarkerId();
            if (newMarker == null) {
                iterator.remove();
                this.customDecorations.remove(id);
                continue;
            }
            if (!Objects.equals(id, ((MapBlockMarker)newMarker).getMarkerId()) || !marker.shouldUpdate((MapBlockMarker<?>)newMarker)) continue;
            ((MapBlockMarker)newMarker).updateDecoration(this.customDecorations.get(id));
        }
    }
}

