/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.arguments.EntityTypeArgument;
import de.markusbordihn.easynpc.commands.suggestion.RenderTypeSuggestions;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.RenderHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class RenderCommand
extends Command {
    private RenderCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"render").requires(commandSource -> commandSource.m_6761_(0))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"type").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests(RenderTypeSuggestions::suggest).executes(context -> RenderCommand.setRenderType((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), RenderType.get(StringArgumentType.getString((CommandContext)context, (String)"type")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"entity").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(context -> RenderCommand.setRenderEntityType((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityTypeArgument.getEntityType((CommandContext<CommandSourceStack>)context, "entity")))))));
    }

    private static int setRenderType(CommandSourceStack context, EasyNPC<?> easyNPC, RenderType renderType) {
        if (easyNPC == null || renderType == null) {
            return 0;
        }
        if (!RenderHandler.setRenderType(easyNPC, renderType)) {
            return RenderCommand.sendFailureMessage(context, "Failed to set render type " + renderType + " for EasyNPC " + easyNPC);
        }
        return RenderCommand.sendSuccessMessage(context, "Set render type " + renderType + " for EasyNPC " + easyNPC);
    }

    private static int setRenderEntityType(CommandSourceStack context, EasyNPC<?> easyNPC, EntityType<? extends Entity> entityType) {
        if (easyNPC == null || entityType == null) {
            return 0;
        }
        if (!RenderHandler.setRenderEntity(easyNPC, entityType)) {
            return RenderCommand.sendFailureMessage(context, "Failed to set render entity " + entityType + " for EasyNPC " + easyNPC);
        }
        return RenderCommand.sendSuccessMessage(context, "Set render entity " + entityType + " for EasyNPC with UUID " + easyNPC.m_142081_());
    }
}

