/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.client.pose.PoseManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.PoseSuggestions;
import de.markusbordihn.easynpc.data.animation.AnimationData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;

public class PoseCommand
extends Command {
    private PoseCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pose").requires(commandSource -> commandSource.m_6761_(0))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PoseCommand.resetPose((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(PoseSuggestions::suggest).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PoseCommand.setPose((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"type"))))));
    }

    private static int resetPose(CommandSourceStack context, EasyNPC<?> easyNPC) {
        PoseManager.resetModelPose(easyNPC);
        return PoseCommand.sendSuccessMessage(context, "Resetting pose for Easy NPC " + easyNPC.m_142081_() + " !");
    }

    private static int setPose(CommandSourceStack context, EasyNPC<?> easyNPC, ResourceLocation resourceLocation) {
        AnimationData.Animation animation = PoseManager.getPoseData(resourceLocation);
        if (animation == null) {
            return PoseCommand.sendFailureMessage(context, "Pose " + resourceLocation + " was not found!");
        }
        if (PoseManager.setModelPose(easyNPC, animation)) {
            return PoseCommand.sendSuccessMessage(context, "Setting pose " + resourceLocation + " for Easy NPC " + easyNPC.m_142081_() + " !");
        }
        return PoseCommand.sendFailureMessage(context, "Failed to set pose " + resourceLocation + " for Easy NPC " + easyNPC.m_142081_() + " !");
    }
}

