/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ImportPresetMessage(UUID uuid, PresetType presetType, CompoundTag compoundTag, ResourceLocation resourceLocation) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "import_preset");

    public static ImportPresetMessage create(FriendlyByteBuf buffer) {
        return new ImportPresetMessage(buffer.m_130259_(), (PresetType)buffer.m_130066_(PresetType.class), buffer.m_130260_(), buffer.m_130281_());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.presetType);
        buffer.m_130079_(this.compoundTag);
        buffer.m_130085_(this.resourceLocation);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.presetType) {
            case LOCAL: {
                PresetHandler.importLocalPreset(serverPlayer.m_183503_(), this.compoundTag, this.resourceLocation, easyNPC.getEntity().m_20182_(), this.uuid, null);
                break;
            }
            case CUSTOM: {
                PresetHandler.importCustomPreset(serverPlayer.m_183503_(), this.resourceLocation, easyNPC.getEntity().m_20182_(), this.uuid, null);
                break;
            }
            case DATA: {
                PresetHandler.importDataPreset(serverPlayer.m_183503_(), this.resourceLocation, easyNPC.getEntity().m_20182_(), this.uuid, null);
                break;
            }
            case DEFAULT: {
                PresetHandler.importDefaultPreset(serverPlayer.m_183503_(), this.resourceLocation, easyNPC.getEntity().m_20182_(), this.uuid, null);
                break;
            }
            case WORLD: {
                PresetHandler.importWorldPreset(serverPlayer.m_183503_(), this.resourceLocation, easyNPC.getEntity().m_20182_(), this.uuid, null);
                break;
            }
            default: {
                log.error("Invalid preset type {} from {}", (Object)this.presetType, (Object)serverPlayer);
            }
        }
    }
}

