/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributeType;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributeType;
import de.markusbordihn.easynpc.data.attribute.MovementAttributeType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.data.trading.TradingValueType;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.server.AddOrUpdateObjectiveMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeActionEventMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeAdvancedTradingMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeBasicTradingMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeCombatAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeDisplayAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeEntityAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeEntityBaseAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeEnvironmentalAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeInteractionAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeModelEquipmentVisibilityMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeModelLockRotationMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeModelPositionMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeModelRotationMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeModelVisibilityMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeMovementAttributeMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeNameMessage;
import de.markusbordihn.easynpc.network.message.server.ChangePoseMessage;
import de.markusbordihn.easynpc.network.message.server.ChangePositionMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeProfessionMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeRendererMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeScaleMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeSkinMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeSpawnerSettingMessage;
import de.markusbordihn.easynpc.network.message.server.ChangeTradingTypeMessage;
import de.markusbordihn.easynpc.network.message.server.ExecuteActionEventMessage;
import de.markusbordihn.easynpc.network.message.server.ExecuteDialogButtonActionMessage;
import de.markusbordihn.easynpc.network.message.server.ExportPresetMessage;
import de.markusbordihn.easynpc.network.message.server.ExportWorldPresetMessage;
import de.markusbordihn.easynpc.network.message.server.ImportPresetMessage;
import de.markusbordihn.easynpc.network.message.server.OpenActionDataEditorMessage;
import de.markusbordihn.easynpc.network.message.server.OpenActionDataEntryEditorMessage;
import de.markusbordihn.easynpc.network.message.server.OpenConfigurationMessage;
import de.markusbordihn.easynpc.network.message.server.OpenDialogButtonEditorMessage;
import de.markusbordihn.easynpc.network.message.server.OpenDialogEditorMessage;
import de.markusbordihn.easynpc.network.message.server.OpenDialogTextEditorMessage;
import de.markusbordihn.easynpc.network.message.server.OpenMenuMessage;
import de.markusbordihn.easynpc.network.message.server.RemoveDialogButtonMessage;
import de.markusbordihn.easynpc.network.message.server.RemoveDialogMessage;
import de.markusbordihn.easynpc.network.message.server.RemoveNPCMessage;
import de.markusbordihn.easynpc.network.message.server.RemoveObjectiveMessage;
import de.markusbordihn.easynpc.network.message.server.RequestDataSyncMessage;
import de.markusbordihn.easynpc.network.message.server.RespawnNPCMessage;
import de.markusbordihn.easynpc.network.message.server.SaveDialogButtonMessage;
import de.markusbordihn.easynpc.network.message.server.SaveDialogMessage;
import de.markusbordihn.easynpc.network.message.server.SaveDialogSetMessage;
import de.markusbordihn.easynpc.validator.UrlValidator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ServerNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    default public void actionEventChange(UUID uuid, ActionEventType actionEventType, ActionDataSet actionDataSet) {
        if (uuid != null && actionEventType != null && actionDataSet != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeActionEventMessage(uuid, actionEventType, actionDataSet));
        }
    }

    default public void addOrUpdateObjective(UUID uuid, ObjectiveDataEntry objectiveDataEntry) {
        if (uuid != null && objectiveDataEntry != null) {
            NetworkHandlerManager.sendMessageToServer(new AddOrUpdateObjectiveMessage(uuid, objectiveDataEntry));
        }
    }

    default public void changeProfession(UUID uuid, Profession profession) {
        if (uuid != null && profession != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeProfessionMessage(uuid, profession));
        }
    }

    default public void changeTradingType(UUID uuid, TradingType tradingType) {
        if (uuid != null && tradingType != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeTradingTypeMessage(uuid, tradingType));
        }
    }

    default public void setAdvancedTradingResetsEveryMin(UUID uuid, int resetsEveryMin) {
        if (uuid != null && resetsEveryMin >= 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeAdvancedTradingMessage(uuid, 9999, TradingValueType.RESET_TRADING_EVERY_MIN, resetsEveryMin));
        }
    }

    default public void setAdvancedTradingMaxUses(UUID uuid, int tradingOfferIndex, int maxUses) {
        if (uuid != null && maxUses > 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeAdvancedTradingMessage(uuid, tradingOfferIndex, TradingValueType.MAX_USES, maxUses));
        }
    }

    default public void setAdvancedTradingRewardExp(UUID uuid, int tradingOfferIndex, int xp) {
        if (uuid != null && xp >= 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeAdvancedTradingMessage(uuid, tradingOfferIndex, TradingValueType.REWARD_EXP, xp));
        }
    }

    default public void setAdvancedTradingPriceMultiplier(UUID uuid, int tradingOfferIndex, float priceMultiplier) {
        if (uuid != null && (double)priceMultiplier >= 0.0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeAdvancedTradingMessage(uuid, tradingOfferIndex, TradingValueType.PRICE_MULTIPLIER, priceMultiplier));
        }
    }

    default public void setAdvancedTradingDemand(UUID uuid, int tradingOfferIndex, int demand) {
        if (uuid != null && demand >= 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeAdvancedTradingMessage(uuid, tradingOfferIndex, TradingValueType.DEMAND, demand));
        }
    }

    default public void changeDisplayAttribute(UUID uuid, DisplayAttributeType displayAttributeType, Boolean booleanValue) {
        if (uuid != null && displayAttributeType != null && booleanValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeDisplayAttributeMessage(uuid, displayAttributeType, booleanValue));
        }
    }

    default public void changeDisplayAttribute(UUID uuid, DisplayAttributeType displayAttributeType, Integer integerValue) {
        if (uuid != null && displayAttributeType != null && integerValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeDisplayAttributeMessage(uuid, displayAttributeType, integerValue));
        }
    }

    default public void entityAttributeChange(UUID uuid, EntityAttribute entityAttribute, Boolean booleanValue) {
        if (uuid != null && entityAttribute != null && booleanValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeEntityAttributeMessage(uuid, entityAttribute, booleanValue));
        }
    }

    default public void combatAttributeChange(UUID uuid, CombatAttributeType attributeType, Boolean booleanValue) {
        if (uuid != null && attributeType != null && booleanValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeCombatAttributeMessage(uuid, attributeType, booleanValue));
        }
    }

    default public void combatAttributeChange(UUID uuid, CombatAttributeType attributeType, Double doubleValue) {
        if (uuid != null && attributeType != null && doubleValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeCombatAttributeMessage(uuid, attributeType, doubleValue));
        }
    }

    default public void environmentalAttributeChange(UUID uuid, EnvironmentalAttributeType attributeType, Boolean booleanValue) {
        if (uuid != null && attributeType != null && booleanValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeEnvironmentalAttributeMessage(uuid, attributeType, booleanValue));
        }
    }

    default public void interactionAttributeChange(UUID uuid, InteractionAttributeType attributeType, Boolean booleanValue) {
        if (uuid != null && attributeType != null && booleanValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeInteractionAttributeMessage(uuid, attributeType, booleanValue));
        }
    }

    default public void movementAttributeChange(UUID uuid, MovementAttributeType attributeType, Boolean booleanValue) {
        if (uuid != null && attributeType != null && booleanValue != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeMovementAttributeMessage(uuid, attributeType, booleanValue));
        }
    }

    default public void setBasicTradingMaxUses(UUID uuid, int maxUses) {
        if (uuid != null && maxUses > 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeBasicTradingMessage(uuid, TradingValueType.MAX_USES, maxUses));
        }
    }

    default public void setBasicTradingRewardExp(UUID uuid, int rewardExp) {
        if (uuid != null && rewardExp >= 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeBasicTradingMessage(uuid, TradingValueType.REWARD_EXP, rewardExp));
        }
    }

    default public void setBasicTradingResetsEveryMin(UUID uuid, int resetsEveryMin) {
        if (uuid != null && resetsEveryMin >= 0) {
            NetworkHandlerManager.sendMessageToServer(new ChangeBasicTradingMessage(uuid, TradingValueType.RESET_TRADING_EVERY_MIN, resetsEveryMin));
        }
    }

    default public void openActionDataEditor(UUID uuid, ActionEventType actionEventType, ConfigurationType configurationType) {
        if (uuid != null && actionEventType != null && actionEventType != ActionEventType.NONE) {
            NetworkHandlerManager.sendMessageToServer(new OpenActionDataEditorMessage(uuid, Constants.EMPTY_UUID, Constants.EMPTY_UUID, actionEventType, configurationType, EditorType.NONE));
        }
    }

    default public void openActionDataEditor(UUID uuid, EditorType editorType, UUID dialogId, UUID dialogButtonId) {
        if (uuid != null && editorType != null && dialogId != null && dialogButtonId != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenActionDataEditorMessage(uuid, dialogId, dialogButtonId, ActionEventType.NONE, ConfigurationType.NONE, editorType));
        }
    }

    default public void openActionDataEntryEditor(UUID uuid, EditorType editorType, UUID dialogId, UUID dialogButtonId, ActionDataEntry actionDataEntry) {
        if (uuid != null && editorType != null && dialogId != null && dialogButtonId != null && actionDataEntry != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenActionDataEntryEditorMessage(uuid, dialogId, dialogButtonId, actionDataEntry.getId(), ActionEventType.NONE, ConfigurationType.NONE, editorType));
        }
    }

    default public void openActionDataEntryEditor(UUID uuid, ActionEventType actionEventType, ConfigurationType configurationType, ActionDataEntry actionDataEntry) {
        if (uuid != null && actionEventType != null && actionDataEntry != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenActionDataEntryEditorMessage(uuid, Constants.EMPTY_UUID, Constants.EMPTY_UUID, actionDataEntry.getId(), actionEventType, configurationType, EditorType.NONE));
        }
    }

    default public void openDialogEditor(UUID uuid, UUID dialogId) {
        if (uuid != null && dialogId != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenDialogEditorMessage(uuid, dialogId));
        }
    }

    default public void openDialogTextEditor(UUID uuid, UUID dialogId) {
        if (uuid != null && dialogId != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenDialogTextEditorMessage(uuid, dialogId));
        }
    }

    default public void openDialogButtonEditor(UUID uuid, UUID dialogId, UUID dialogButtonId) {
        if (uuid != null && dialogId != null && dialogButtonId != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenDialogButtonEditorMessage(uuid, dialogId, dialogButtonId));
        }
    }

    default public void openMenu(UUID uuid, UUID menuId) {
        if (uuid != null && menuId != null) {
            NetworkHandlerManager.sendMessageToServer(new OpenMenuMessage(uuid, menuId));
        }
    }

    default public void saveDialogButton(UUID uuid, UUID dialogId, UUID dialogButtonId, DialogButtonEntry dialogButtonEntry) {
        if (uuid != null && dialogId != null && dialogButtonId != null && dialogButtonEntry != null) {
            NetworkHandlerManager.sendMessageToServer(new SaveDialogButtonMessage(uuid, dialogId, dialogButtonId, dialogButtonEntry));
        }
    }

    default public void removeDialog(UUID uuid, UUID dialogId) {
        if (uuid != null && dialogId != null) {
            NetworkHandlerManager.sendMessageToServer(new RemoveDialogMessage(uuid, dialogId));
        }
    }

    default public void removeDialogButton(UUID uuid, UUID dialogId, UUID dialogButtonId) {
        if (uuid != null && dialogId != null && dialogButtonId != null) {
            NetworkHandlerManager.sendMessageToServer(new RemoveDialogButtonMessage(uuid, dialogId, dialogButtonId));
        }
    }

    default public void saveDialogSet(UUID uuid, DialogDataSet dialogDataSet) {
        if (uuid != null && dialogDataSet != null) {
            NetworkHandlerManager.sendMessageToServer(new SaveDialogSetMessage(uuid, dialogDataSet));
        }
    }

    default public void saveDialog(UUID uuid, UUID dialogId, DialogDataEntry dialogData) {
        if (uuid != null && dialogId != null && dialogData != null) {
            NetworkHandlerManager.sendMessageToServer(new SaveDialogMessage(uuid, dialogId, dialogData));
        }
    }

    default public void openConfiguration(UUID uuid, ConfigurationType configurationType, int pageIndex) {
        if (uuid != null && configurationType != null && pageIndex >= 0) {
            NetworkHandlerManager.sendMessageToServer(new OpenConfigurationMessage(uuid, configurationType, pageIndex));
        }
    }

    default public void importPreset(UUID uuid, PresetType presetType, ResourceLocation resourceLocation) {
        if (uuid != null && presetType != null && resourceLocation != null) {
            NetworkHandlerManager.sendMessageToServer(new ImportPresetMessage(uuid, presetType, null, resourceLocation));
        }
    }

    default public void importPreset(UUID uuid, PresetType presetType, CompoundTag compoundTag, ResourceLocation resourceLocation) {
        if (uuid != null && presetType != null && compoundTag != null && !compoundTag.m_128456_()) {
            NetworkHandlerManager.sendMessageToServer(new ImportPresetMessage(uuid, presetType, compoundTag, resourceLocation));
        }
    }

    default public void changeSpawnerSettings(BlockPos blockPos, SpawnerSettingType spawnerSettingType, int value) {
        if (blockPos != null && spawnerSettingType != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeSpawnerSettingMessage(blockPos, spawnerSettingType, value));
        }
    }

    default public void triggerActionEvent(UUID uuid, ActionEventType actionEventType) {
        if (uuid != null && actionEventType != null && actionEventType != ActionEventType.NONE) {
            NetworkHandlerManager.sendMessageToServer(new ExecuteActionEventMessage(uuid, actionEventType));
        }
    }

    default public void triggerDialogButtonAction(UUID uuid, UUID dialogId, UUID dialogButtonId) {
        if (uuid != null && dialogId != null && dialogButtonId != null) {
            NetworkHandlerManager.sendMessageToServer(new ExecuteDialogButtonActionMessage(uuid, dialogId, dialogButtonId));
        }
    }

    default public void changeName(UUID uuid, String name, int color, boolean visible) {
        if (uuid != null && name != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeNameMessage(uuid, name, color, visible));
        }
    }

    default public void removeNPC(UUID uuid) {
        if (uuid != null) {
            NetworkHandlerManager.sendMessageToServer(new RemoveNPCMessage(uuid));
        }
    }

    default public void respawnNPC(UUID uuid) {
        if (uuid != null) {
            NetworkHandlerManager.sendMessageToServer(new RespawnNPCMessage(uuid));
        }
    }

    default public void exportPreset(UUID uuid, String name) {
        if (uuid != null && name != null && !name.isEmpty()) {
            NetworkHandlerManager.sendMessageToServer(new ExportPresetMessage(uuid, name));
        }
    }

    default public void exportWorldPreset(UUID uuid, String name) {
        if (uuid != null && name != null && !name.isEmpty()) {
            NetworkHandlerManager.sendMessageToServer(new ExportWorldPresetMessage(uuid, name));
        }
    }

    default public void setSkin(UUID uuid, String skinName, String skinURL, UUID skinUUID, SkinType skinType, String skinVariant) {
        if (uuid != null && skinUUID != null && skinType != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeSkinMessage(uuid, skinName, skinURL, skinUUID, skinType, skinVariant));
        }
    }

    default public void importCustomPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.CUSTOM, resourceLocation);
    }

    default public void importDefaultPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.DEFAULT, resourceLocation);
    }

    default public void importLocalPreset(UUID uuid, CompoundTag compoundTag, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.LOCAL, compoundTag, resourceLocation);
    }

    default public void importWorldPreset(UUID uuid, ResourceLocation resourceLocation) {
        this.importPreset(uuid, PresetType.WORLD, resourceLocation);
    }

    default public void openConfiguration(UUID uuid, ConfigurationType configurationType) {
        this.openConfiguration(uuid, configurationType, 0);
    }

    default public void openDialogEditor(UUID uuid) {
        this.openDialogEditor(uuid, new UUID(0L, 0L));
    }

    default public void openDialogButtonEditor(UUID uuid, UUID dialogId) {
        this.openDialogButtonEditor(uuid, dialogId, new UUID(0L, 0L));
    }

    default public void setNoneSkin(UUID uuid) {
        if (uuid != null) {
            this.setSkin(uuid, "", "", Constants.BLANK_UUID, SkinType.NONE, "");
        }
    }

    default public void setDefaultSkin(UUID uuid, Enum<?> variant) {
        if (uuid != null && variant != null) {
            this.setSkin(uuid, "", "", Constants.BLANK_UUID, SkinType.DEFAULT, variant.name());
        }
    }

    default public void poseChange(UUID uuid, Pose pose) {
        if (uuid != null && pose != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangePoseMessage(uuid, pose));
        }
    }

    default public void positionChange(UUID uuid, Vec3 pos) {
        if (uuid != null && pos != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangePositionMessage(uuid, pos));
        }
    }

    default public void entityBaseAttributeChange(UUID uuid, Attribute attribute, Double value) {
        if (uuid != null && attribute != null && value != null && Registry.f_122866_.m_7981_((Object)attribute) != null) {
            Double roundedValue = (double)Math.round(value * 100.0) / 100.0;
            NetworkHandlerManager.sendMessageToServer(new ChangeEntityBaseAttributeMessage(uuid, Registry.f_122866_.m_7981_((Object)attribute), roundedValue));
        }
    }

    default public void modelLockRotationChange(UUID uuid, boolean lockRotation) {
        if (uuid != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeModelLockRotationMessage(uuid, lockRotation));
        }
    }

    default public void modelPositionChange(UUID uuid, ModelPart modelPart, CustomPosition position) {
        if (uuid != null && modelPart != null && position != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeModelPositionMessage(uuid, modelPart, position));
        }
    }

    default public void modelVisibilityChange(UUID uuid, EquipmentSlot equipmentSlot, boolean visible) {
        if (uuid != null && equipmentSlot != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeModelEquipmentVisibilityMessage(uuid, equipmentSlot, visible));
        }
    }

    default public void modelVisibilityChange(UUID uuid, ModelPart modelPart, boolean visible) {
        if (uuid != null && modelPart != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeModelVisibilityMessage(uuid, modelPart, visible));
        }
    }

    default public void rotationChange(UUID uuid, ModelPart modelPart, CustomRotation rotation) {
        if (uuid != null && modelPart != null && rotation != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeModelRotationMessage(uuid, modelPart, rotation));
        }
    }

    default public void scaleChange(UUID uuid, ModelScaleAxis modelScaleAxis, float scale) {
        if (uuid != null && modelScaleAxis != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeScaleMessage(uuid, modelScaleAxis, Float.valueOf(scale)));
        }
    }

    default public void setCustomSkin(UUID uuid, UUID skinUUID) {
        if (uuid != null && skinUUID != null) {
            this.setSkin(uuid, "", "", skinUUID, SkinType.CUSTOM, "");
        }
    }

    default public void setPlayerSkin(UUID uuid, String playerName, UUID playerUUID) {
        if (uuid != null && playerName != null && playerUUID != null) {
            this.setSkin(uuid, playerName, "", playerUUID, SkinType.PLAYER_SKIN, "");
        }
    }

    default public void setRemoteSkin(UUID uuid, String skinURL) {
        if (uuid != null && UrlValidator.isValidUrl(skinURL)) {
            this.setSkin(uuid, "", skinURL, Constants.BLANK_UUID, SkinType.INSECURE_REMOTE_URL, "");
        }
    }

    default public void removeObjective(UUID uuid, ObjectiveDataEntry objectiveDataEntry) {
        if (uuid != null && objectiveDataEntry != null) {
            NetworkHandlerManager.sendMessageToServer(new RemoveObjectiveMessage(uuid, objectiveDataEntry));
        }
    }

    default public void requestDataSync(UUID uuid) {
        if (uuid != null) {
            NetworkHandlerManager.sendMessageToServer(new RequestDataSyncMessage(uuid));
        }
    }

    default public void setRenderType(UUID uuid, RenderType renderType) {
        if (uuid != null && renderType != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeRendererMessage(uuid, renderType, Optional.empty()));
        }
    }

    default public void setRenderEntityType(UUID uuid, EntityType<?> entityType) {
        if (uuid != null && entityType != null) {
            NetworkHandlerManager.sendMessageToServer(new ChangeRendererMessage(uuid, RenderType.CUSTOM, Optional.of(entityType)));
        }
    }
}

