/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import de.markusbordihn.easynpc.network.message.client.ExportClientPresetMessage;
import de.markusbordihn.easynpc.network.message.client.OpenMenuCallbackMessage;
import de.markusbordihn.easynpc.network.message.client.SyncDataMessage;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ClientNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    default public void exportClientPreset(UUID uuid, String name, ServerPlayer serverPlayer) {
        if (name == null || name.isEmpty() || !NetworkMessageRecord.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        CompoundTag compoundTag = presetData.exportPresetData();
        log.info("Exporting preset for {} to {}", (Object)easyNPC.getEntity().m_7755_().getString(), (Object)serverPlayer.m_7755_().getString());
        NetworkHandlerManager.sendMessageToPlayer(new ExportClientPresetMessage(uuid, easyNPC.getEntity().m_7755_().getString(), easyNPC.getEasyNPCSkinData().getSkinModel(), name, compoundTag), serverPlayer);
    }

    default public void openMenu(UUID uuid, UUID menuId, ServerPlayer serverPlayer, CompoundTag data) {
        if (uuid != null && menuId != null && serverPlayer != null) {
            log.debug("Open menu {} for npc {} and player {} with: {}", (Object)menuId, (Object)uuid, (Object)serverPlayer, (Object)data);
            NetworkHandlerManager.sendMessageToPlayer(new OpenMenuCallbackMessage(uuid, menuId, data), serverPlayer);
        }
    }

    default public void syncData(EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        if (easyNPC != null && serverPlayer != null) {
            log.debug("Sync {} data to player {}", easyNPC, (Object)serverPlayer);
            NetworkHandlerManager.sendMessageToPlayer(new SyncDataMessage(easyNPC.m_142081_(), easyNPC.getEasyNPCDialogData() != null ? easyNPC.getEasyNPCDialogData().getDialogDataSet() : null), serverPlayer);
        }
    }
}

