/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler
implements NetworkHandlerInterface {
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("easy_npc", "network"), () -> String.valueOf(23), String.valueOf(23)::equals, String.valueOf(23)::equals);
    private static int id = 0;
    private final Map<ResourceLocation, Class<? extends NetworkMessageRecord>> clientMessages = new LinkedHashMap<ResourceLocation, Class<? extends NetworkMessageRecord>>();
    private final Map<ResourceLocation, Class<? extends NetworkMessageRecord>> serverMessages = new LinkedHashMap<ResourceLocation, Class<? extends NetworkMessageRecord>>();
    private final Map<ResourceLocation, Class<? extends NetworkMessageRecord>> registeredClientMessages = new LinkedHashMap<ResourceLocation, Class<? extends NetworkMessageRecord>>();
    private final Map<ResourceLocation, Class<? extends NetworkMessageRecord>> registeredServerMessages = new LinkedHashMap<ResourceLocation, Class<? extends NetworkMessageRecord>>();

    public NetworkHandler() {
        log.info("{} Network Handler for {} with version {}", (Object)"\ud83d\udde3 Register Easy NPC", (Object)INSTANCE, (Object)23);
    }

    public void sendToServer(NetworkMessageRecord networkMessageRecord) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> INSTANCE.sendToServer((Object)networkMessageRecord));
    }

    public void sendToPlayer(NetworkMessageRecord networkMessageRecord, ServerPlayer serverPlayer) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)networkMessageRecord);
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(ResourceLocation messageID, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        int registrationID = id++;
        this.logRegisterClientNetworkMessageHandler(messageID, networkMessage, registrationID);
        INSTANCE.registerMessage(registrationID, networkMessage, NetworkMessageRecord::write, creator, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> message::handleClient));
            context.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(ResourceLocation messageID, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        int registrationID = id++;
        this.logRegisterServerNetworkMessageHandler(messageID, networkMessage, registrationID);
        INSTANCE.registerMessage(registrationID, networkMessage, NetworkMessageRecord::write, creator, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> message.handleServer(context.getSender()));
            context.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @Override
    public <M extends NetworkMessageRecord> void addClientMessage(ResourceLocation messageID, Class<M> networkMessage) {
        this.clientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addServerMessage(ResourceLocation messageID, Class<M> networkMessage) {
        this.serverMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getClientMessages() {
        return this.clientMessages;
    }

    @Override
    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getServerMessages() {
        return this.serverMessages;
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(ResourceLocation messageID, Class<M> networkMessage) {
        this.registeredClientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(ResourceLocation messageID, Class<M> networkMessage) {
        this.registeredServerMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages() {
        return this.registeredClientMessages;
    }

    @Override
    public Map<ResourceLocation, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages() {
        return this.registeredServerMessages;
    }
}

