/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.configuration;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.trading.AdvancedTradingConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.trading.BasicTradingConfigurationMenu;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class ConfigurationMenuHandler {
    public static MenuProvider getMenuProvider(ConfigurationType configurationType, EasyNPC<?> easyNPC, final MenuType<? extends ConfigurationMenu> menuType, final ScreenData screenData) {
        final Component displayName = configurationType.getConfigurationTitle(easyNPC);
        if (configurationType == ConfigurationType.EQUIPMENT) {
            return new MenuProvider(){

                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    return new EquipmentConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public Component m_5446_() {
                    return displayName;
                }
            };
        }
        if (configurationType == ConfigurationType.ADVANCED_TRADING) {
            return new MenuProvider(){

                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    return new AdvancedTradingConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public Component m_5446_() {
                    return displayName;
                }
            };
        }
        if (configurationType == ConfigurationType.BASIC_TRADING) {
            return new MenuProvider(){

                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    return new BasicTradingConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public Component m_5446_() {
                    return displayName;
                }
            };
        }
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new ConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public Component m_5446_() {
                return displayName;
            }
        };
    }

    public static ScreenData getScreenData(ConfigurationType configurationType, EasyNPC<?> easyNPC, ServerPlayer serverPlayer, int pageIndex) {
        UUID npcUUID = easyNPC.m_142081_();
        CompoundTag additionalSyncData = new CompoundTag();
        switch (configurationType) {
            case DEFAULT_PRESET_IMPORT: {
                Set<ResourceLocation> defaultPresets = DefaultPresetDataFiles.getPresetResourceLocations(serverPlayer.m_20194_()).collect(Collectors.toSet());
                additionalSyncData.m_128365_("DefaultPresets", (Tag)CompoundTagUtils.writeResourceLocations(defaultPresets));
                break;
            }
            case CUSTOM_PRESET_IMPORT: {
                Set<ResourceLocation> customPresets = CustomPresetDataFiles.getPresetResourceLocations().collect(Collectors.toSet());
                additionalSyncData.m_128365_("CustomPresets", (Tag)CompoundTagUtils.writeResourceLocations(customPresets));
                break;
            }
            case WORLD_PRESET_IMPORT: {
                Set<ResourceLocation> worldPresets = WorldPresetDataFiles.getPresetResourceLocations().collect(Collectors.toSet());
                additionalSyncData.m_128365_("WorldPresets", (Tag)CompoundTagUtils.writeResourceLocations(worldPresets));
                break;
            }
            case BASIC_ACTION: 
            case DIALOG_ACTION: 
            case DISTANCE_ACTION: {
                AdditionalScreenData.addActionEventSet(additionalSyncData, easyNPC);
                break;
            }
            case BASE_ATTRIBUTE: {
                AdditionalScreenData.addBaseAttributes(additionalSyncData, easyNPC);
                break;
            }
            case NONE_DIALOG: 
            case BASIC_DIALOG: 
            case YES_NO_DIALOG: 
            case ADVANCED_DIALOG: {
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
            case ATTACK_OBJECTIVE: 
            case BASIC_OBJECTIVE: 
            case FOLLOW_OBJECTIVE: 
            case LOOK_OBJECTIVE: {
                AdditionalScreenData.addObjectiveDataSet(additionalSyncData, easyNPC);
                break;
            }
        }
        return new ScreenData(npcUUID, null, null, null, pageIndex, additionalSyncData);
    }
}

