/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MaterialColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModSpawnEggItem
extends SpawnEggItem {
    public static final String SUFFIX = "_spawn_egg";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;

    public ModSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> entityType, Item.Properties properties) {
        super(null, MaterialColor.f_76364_.f_76396_, MaterialColor.f_76416_.f_76396_, properties);
        this.typeSupplier = entityType;
    }

    public ModSpawnEggItem(EntityType<? extends Mob> entityType, Item.Properties properties) {
        super(null, MaterialColor.f_76364_.f_76396_, MaterialColor.f_76416_.f_76396_, properties);
        this.typeSupplier = () -> entityType;
    }

    public Component m_7626_(ItemStack itemStack) {
        String descriptionId = this.m_5671_(itemStack);
        if (descriptionId.contains(SUFFIX)) {
            return TextComponent.getTranslatedTextRaw("item.easy_npc.spawn_egg", (Component)TextComponent.getTranslatedTextRaw(this.m_5671_(itemStack).replace("item.easy_npc.", "entity.easy_npc.").replace(SUFFIX, "")));
        }
        return TextComponent.getTranslatedTextRaw(this.m_5671_(itemStack));
    }

    public EntityType<?> m_43228_(CompoundTag tag) {
        EntityType<? extends Mob> type = super.m_43228_(tag);
        return type != null ? type : this.typeSupplier.get();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockState = level.m_8055_(blockPos);
        BlockPos blockPos1 = blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_142300_(direction);
        EntityType<?> entityType = this.m_43228_(itemStack.m_41783_());
        Entity entity = entityType.m_20592_((ServerLevel)level, itemStack, context.m_43723_(), blockPos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos1) && direction == Direction.UP);
        if (entity != null) {
            if (entity instanceof EasyNPC) {
                OwnerData ownerData;
                EasyNPC easyNPC = (EasyNPC)entity;
                if (player != null && (ownerData = easyNPC.getEasyNPCOwnerData()) != null) {
                    ownerData.setOwnerUUID(player.m_142081_());
                }
            }
            itemStack.m_41774_(1);
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, blockPos);
        }
        return InteractionResult.CONSUME;
    }
}

