/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.client.pose.PoseManager;
import de.markusbordihn.easynpc.data.animation.AnimationData;
import de.markusbordihn.easynpc.data.animation.AnimationDataReader;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPoseDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String DATA_FOLDER_NAME = "pose";
    protected static final String TEMPLATE_PREFIX = "_poses.json";

    private CustomPoseDataFiles() {
    }

    public static void registerCustomPoseData(MinecraftServer minecraftServer) {
        log.info("{} custom pose data ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Path poseDataFolder = CustomPoseDataFiles.getCustomPoseDataFolder();
        if (poseDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            Path poseModelFolder = CustomPoseDataFiles.getCustomPoseDataFolder(skinModel);
            if (poseModelFolder == null) continue;
            String skinModelName = skinModel.getName();
            Collection resourceLocations = minecraftServer.m_177941_().m_6540_("poses/" + skinModelName, fileName -> fileName.endsWith(TEMPLATE_PREFIX));
            for (ResourceLocation resourceLocation : resourceLocations) {
                File skinModelPoseFile = poseModelFolder.resolve(DataFileHandler.getFileNameFromResourceLocation(resourceLocation)).toFile();
                if (skinModelPoseFile.exists()) {
                    log.warn("Skin model pose file {} already exists, skipping copy!", (Object)skinModelPoseFile);
                    continue;
                }
                log.info("Copy skin model pose file {} to {} ...", (Object)resourceLocation, (Object)skinModelPoseFile);
                DataFileHandler.copyResourceFile(minecraftServer, resourceLocation, skinModelPoseFile);
            }
        }
        CustomPoseDataFiles.registerCustomPoseFiles();
    }

    public static void registerCustomPoseFiles() {
        Path poseDataFolder = CustomPoseDataFiles.getCustomPoseDataFolder();
        if (poseDataFolder == null) {
            return;
        }
        log.info("{} custom poses from {} ...", (Object)"\ud83d\udde3 Register Easy NPC", (Object)poseDataFolder);
        for (SkinModel skinModel : SkinModel.values()) {
            Path poseModelFolder = CustomPoseDataFiles.getCustomPoseDataFolder(skinModel);
            if (poseModelFolder == null || !poseModelFolder.toFile().exists() || !poseModelFolder.toFile().isDirectory()) continue;
            try (Stream<Path> posePaths = Files.walk(poseModelFolder, new FileVisitOption[0]);){
                posePaths.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(TEMPLATE_PREFIX)).forEach(path -> {
                    log.info("Found custom pose file {} ...", path);
                    try {
                        AnimationData animationData = AnimationDataReader.parseAnimationFile(path);
                        PoseManager.registerPoseData(skinModel, animationData);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException e) {
                log.error("Error reading custom pose files from {}:", (Object)poseModelFolder, (Object)e);
            }
        }
    }

    public static Path getCustomPoseDataFolder() {
        return DataFileHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getCustomPoseDataFolder(SkinModel skinModel) {
        Path poseDataFolder = CustomPoseDataFiles.getCustomPoseDataFolder();
        if (poseDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path poseDataFolderPath = poseDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(poseDataFolderPath, new LinkOption[0]) && Files.isDirectory(poseDataFolderPath, new LinkOption[0])) {
                return poseDataFolderPath;
            }
            log.info("Created new pose data folder {} at {}!", (Object)skinModelName, (Object)poseDataFolderPath);
            return Files.createDirectories(poseDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Error creating pose data folder {} at {}:", (Object)skinModelName, (Object)poseDataFolderPath, (Object)e);
            return null;
        }
    }
}

