/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;

public interface PresetData<T extends PathfinderMob>
extends EasyNPC<T> {
    default public CompoundTag exportPresetData() {
        CompoundTag compoundTag = this.serializePresetData();
        if (compoundTag.m_128441_("SpawnerUUID")) {
            compoundTag.m_128473_("SpawnerUUID");
        }
        return compoundTag;
    }

    default public void importPresetData(CompoundTag compoundTag) {
        if (compoundTag == null || compoundTag.m_128456_() || this.getEntity() == null) {
            return;
        }
        if (this.getEntity() != null) {
            this.getEntity().m_20124_(Pose.STANDING);
        }
        if (this.getEasyNPCModelData() != null) {
            this.getEasyNPCModelData().setModelPose(ModelPose.DEFAULT);
        }
        if (this.getEasyNPCActionEventData() != null) {
            this.getEasyNPCActionEventData().clearActionEventSet();
        }
        if (this.getEasyNPCDialogData() != null) {
            this.getEasyNPCDialogData().clearDialogDataSet();
        }
        if (!compoundTag.m_128441_("UUID") || !compoundTag.m_128441_("Pos")) {
            CompoundTag existingCompoundTag = this.serializePresetData();
            if (existingCompoundTag.m_128441_("DialogData")) {
                existingCompoundTag.m_128473_("DialogData");
            }
            if (existingCompoundTag.m_128441_("ModelData")) {
                existingCompoundTag.m_128473_("ModelData");
            }
            if (existingCompoundTag.m_128441_("SkinData")) {
                existingCompoundTag.m_128473_("SkinData");
            }
            if (existingCompoundTag.m_128441_("RenderData")) {
                existingCompoundTag.m_128473_("RenderData");
            }
            if (existingCompoundTag.m_128441_("ActionData")) {
                existingCompoundTag.m_128473_("ActionData");
            }
            log.debug("Merging preset {} with existing data {} for {}", (Object)compoundTag, (Object)existingCompoundTag, (Object)this);
            compoundTag = existingCompoundTag.m_128391_(compoundTag);
        } else {
            log.debug("Importing full preset {} for {}", (Object)compoundTag, (Object)this);
        }
        if (compoundTag.m_128441_("Motion")) {
            compoundTag.m_128473_("Motion");
        }
        this.getEntity().m_20258_(compoundTag);
    }

    default public CompoundTag serializePresetData() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.getEntity() == null) {
            return compoundTag;
        }
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            compoundTag.m_128359_("id", entityTypeId);
        }
        return this.getEntity().m_20240_(compoundTag);
    }
}

