/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;

public interface ConfigData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String DATA_EASY_NPC_DATA_VERSION_TAG = "EasyNPCVersion";

    default public void addAdditionalConfigData(CompoundTag compoundTag) {
        compoundTag.m_128405_(DATA_EASY_NPC_DATA_VERSION_TAG, 3);
    }

    default public void readAdditionalConfigData(CompoundTag compoundTag) {
        if (compoundTag.m_128441_(DATA_EASY_NPC_DATA_VERSION_TAG)) {
            int npcDataVersion = compoundTag.m_128451_(DATA_EASY_NPC_DATA_VERSION_TAG);
            if (npcDataVersion > 3) {
                log.warn("Incompatible Easy NPC Data with version {} > {} for {}!", (Object)npcDataVersion, (Object)3, (Object)this);
                log.warn("Will try to load data, but expect issues!");
            } else if (npcDataVersion < 3) {
                log.warn("Outdated Easy NPC Data with version {} for {}!", (Object)npcDataVersion, (Object)this);
                log.warn("Will try to convert data automatically to new format.");
            } else {
                log.info("Easy NPC Data version {} for {}.", (Object)npcDataVersion, (Object)this);
            }
            this.setNPCDataVersion(npcDataVersion);
        } else {
            log.warn("Legacy Easy NPC Data for {}!", (Object)this);
            log.warn("It could be possible that the data is not compatible with the current version.");
            this.setNPCDataVersion(-1);
        }
    }
}

