/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowLivingEntityGoal
extends Goal {
    private final PathfinderMob pathfinderMob;
    private final LivingEntity livingEntity;
    private final double speedModifier;
    private final float stopDistance;
    private final float startDistance;
    private final boolean canFly;
    private final PathNavigation pathNavigation;
    private final LevelReader level;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public FollowLivingEntityGoal(EasyNPC<?> easyNPC, LivingEntity livingEntity, double speedModifier, float stopDistance, float startDistance) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        NavigationData<?> navigationData = easyNPC.getEasyNPCNavigationData();
        this.livingEntity = livingEntity;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.startDistance = startDistance;
        this.canFly = navigationData.canFly();
        this.pathNavigation = this.pathfinderMob.m_21573_();
        this.level = easyNPC.getServerLevel();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.pathfinderMob != null && this.pathfinderMob.m_6084_() && this.livingEntity != null && this.livingEntity.m_6084_() && this.pathfinderMob.m_20280_((Entity)this.livingEntity) > (double)(this.stopDistance * this.stopDistance) && this.pathfinderMob.m_20280_((Entity)this.livingEntity) < (double)(this.startDistance * this.startDistance);
    }

    public boolean m_8045_() {
        if (this.pathNavigation.m_26571_()) {
            return false;
        }
        return this.pathfinderMob.m_20280_((Entity)this.livingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.pathfinderMob.m_21439_(BlockPathTypes.WATER);
        this.pathfinderMob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.pathNavigation.m_26573_();
        this.pathfinderMob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.pathfinderMob.m_21563_().m_24960_((Entity)this.livingEntity, 10.0f, (float)this.pathfinderMob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.pathfinderMob.m_21523_() && !this.pathfinderMob.m_20159_()) {
                if (this.pathfinderMob.m_20280_((Entity)this.livingEntity) >= 144.0) {
                    this.teleportToLivingEntity();
                } else {
                    this.pathNavigation.m_5624_((Entity)this.livingEntity, this.speedModifier);
                }
            }
        }
    }

    private void teleportToLivingEntity() {
        BlockPos blockPos = this.livingEntity.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int posX, int posY, int posZ) {
        if (Math.abs((double)posX - this.livingEntity.m_20185_()) < 2.0 && Math.abs((double)posZ - this.livingEntity.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(posX, posY, posZ))) {
            return false;
        }
        this.pathfinderMob.m_7678_((double)posX + 0.5, (double)posY, (double)posZ + 0.5, this.pathfinderMob.m_146908_(), this.pathfinderMob.m_146909_());
        this.pathNavigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        BlockPathTypes blockPathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (!this.canFly && blockPathTypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.m_8055_(blockPos.m_7495_());
        if (!this.canFly && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos targetBlockPos = blockPos.m_141950_((Vec3i)this.pathfinderMob.m_142538_());
        return this.level.m_45756_((Entity)this.pathfinderMob, this.pathfinderMob.m_142469_().m_82338_(targetBlockPos));
    }

    private int randomIntInclusive(int fromRange, int toRange) {
        return this.pathfinderMob.m_21187_().nextInt(toRange - fromRange + 1) + fromRange;
    }
}

