/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import de.markusbordihn.easynpc.data.sound.SoundType;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundDataEntry {
    public static final String DATA_SOUND_ENABLED_TAG = "Enabled";
    public static final String DATA_SOUND_NAME_TAG = "Name";
    public static final String DATA_SOUND_PITCH_TAG = "Pitch";
    public static final String DATA_SOUND_TYPE = "Type";
    public static final String DATA_SOUND_VOLUME_TAG = "Volume";
    public static final boolean DEFAULT_ENABLED = true;
    public static final float DEFAULT_PITCH = 1.0f;
    public static final float DEFAULT_VOLUME = 0.75f;
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private boolean enabled = true;
    private float pitch = 1.0f;
    private SoundEvent soundEvent;
    private SoundType type;
    private float volume = 0.75f;

    public SoundDataEntry(SoundType type, ResourceLocation location) {
        this(type, location, 0.75f, 1.0f, true);
    }

    public SoundDataEntry(SoundType type, ResourceLocation location, float volume, float pitch, boolean enabled) {
        this.type = type;
        this.volume = volume;
        this.pitch = pitch;
        this.enabled = enabled;
        this.soundEvent = Registry.f_122821_.m_6612_(location).orElseGet(() -> new SoundEvent(location));
    }

    public SoundDataEntry(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public SoundType getType() {
        return this.type;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public void load(CompoundTag compoundTag) {
        this.type = SoundType.valueOf(compoundTag.m_128461_(DATA_SOUND_TYPE));
        if (compoundTag.m_128441_(DATA_SOUND_NAME_TAG)) {
            ResourceLocation location = new ResourceLocation(compoundTag.m_128461_(DATA_SOUND_NAME_TAG));
            this.soundEvent = Registry.f_122821_.m_6612_(location).orElseGet(() -> new SoundEvent(location));
        } else {
            log.error("Unable to load sound event for type {} and {}", (Object)this.type.name(), (Object)compoundTag);
            this.soundEvent = SoundEvents.f_11913_;
        }
        if (compoundTag.m_128441_(DATA_SOUND_VOLUME_TAG)) {
            this.volume = compoundTag.m_128457_(DATA_SOUND_VOLUME_TAG);
        }
        if (compoundTag.m_128441_(DATA_SOUND_PITCH_TAG)) {
            this.pitch = compoundTag.m_128457_(DATA_SOUND_PITCH_TAG);
        }
        if (compoundTag.m_128441_(DATA_SOUND_ENABLED_TAG)) {
            this.enabled = compoundTag.m_128471_(DATA_SOUND_ENABLED_TAG);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_SOUND_TYPE, this.type.name());
        compoundTag.m_128359_(DATA_SOUND_NAME_TAG, this.soundEvent.m_11660_().toString());
        if (this.volume != 0.75f) {
            compoundTag.m_128350_(DATA_SOUND_VOLUME_TAG, this.volume);
        }
        if (this.pitch != 1.0f) {
            compoundTag.m_128350_(DATA_SOUND_PITCH_TAG, this.pitch);
        }
        if (!this.enabled) {
            compoundTag.m_128379_(DATA_SOUND_ENABLED_TAG, this.enabled);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }
}

