/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.EntityAttributesInterface;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributeType;
import net.minecraft.nbt.CompoundTag;

public record EnvironmentalAttributes(boolean canFloat, boolean canBreatheUnderwater, boolean freefall) implements EntityAttributesInterface
{
    public static final String FREEFALL_TAG = EnvironmentalAttributeType.FREEFALL.getTagName();
    public static final String FLOAT_TAG = EnvironmentalAttributeType.CAN_FLOAT.getTagName();
    public static final String BREATHE_UNDERWATER_TAG = EnvironmentalAttributeType.CAN_BREATHE_UNDERWATER.getTagName();

    public EnvironmentalAttributes() {
        this(false, false, false);
    }

    public static EnvironmentalAttributes decode(CompoundTag compoundTag) {
        return new EnvironmentalAttributes(compoundTag.m_128471_(BREATHE_UNDERWATER_TAG), compoundTag.m_128471_(FLOAT_TAG), compoundTag.m_128471_(FREEFALL_TAG));
    }

    public EnvironmentalAttributes withCanBreathUnderwater(boolean canBreathUnderwater) {
        return new EnvironmentalAttributes(this.canFloat, canBreathUnderwater, this.freefall);
    }

    public EnvironmentalAttributes withCanFloat(boolean canFloat) {
        return new EnvironmentalAttributes(canFloat, this.canBreatheUnderwater, this.freefall);
    }

    public EnvironmentalAttributes withFreefall(boolean freefall) {
        return new EnvironmentalAttributes(this.canFloat, this.canBreatheUnderwater, freefall);
    }

    public CompoundTag encode(CompoundTag compoundTag) {
        compoundTag.m_128379_(BREATHE_UNDERWATER_TAG, this.canBreatheUnderwater);
        compoundTag.m_128379_(FLOAT_TAG, this.canFloat);
        compoundTag.m_128379_(FREEFALL_TAG, this.freefall);
        return compoundTag;
    }
}

