/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DialogTextEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_DIALOG_TEXTS = 6;
    private final Set<TextField> dialogTextFields = new HashSet<TextField>();
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogTextButton;
    protected Button saveButton;
    protected Button cancelButton;

    public DialogTextEditorScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void saveDialogData() {
        HashSet<DialogTextData> validDialogTexts = new HashSet<DialogTextData>();
        for (TextField textfield : this.dialogTextFields) {
            String text = textfield.m_94155_();
            if (text.isEmpty()) continue;
            validDialogTexts.add(new DialogTextData(text));
        }
        DialogDataEntry dialogDataEntry = this.getDialogData(this.getDialogUUID());
        dialogDataEntry.setDialogTexts(validDialogTexts);
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 18, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.dialogTextButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.dialogButton.f_93620_ + this.dialogButton.m_5711_(), this.topPos + 7, 140, "Dialog Text", onPress -> {}));
        this.dialogTextButton.f_93623_ = false;
        int dialogTextIndex = 0;
        int dialogTextLeftPos = this.leftPos + 20;
        int dialogTextTopPos = this.topPos + 50;
        int dialogTextWidth = 290;
        Set<DialogTextData> dialogTexts = this.getDialogData(this.getDialogUUID()).getDialogTexts();
        for (DialogTextData dialogText : dialogTexts) {
            if (dialogTextIndex >= 6) break;
            TextField textfield = (TextField)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, dialogTextLeftPos, dialogTextTopPos + dialogTextIndex * 20, dialogTextWidth, dialogText.text(), 512));
            this.dialogTextFields.add(textfield);
            ++dialogTextIndex;
        }
        for (int i = dialogTextIndex; i < 6; ++i) {
            TextField textfield = (TextField)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, dialogTextLeftPos, dialogTextTopPos + i * 20, dialogTextWidth, "", 512));
            this.dialogTextFields.add(textfield);
        }
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.saveButton.f_93620_ + 95 + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
    }

    protected void renderEditLabels(PoseStack poseStack) {
        Text.drawConfigString(poseStack, this.f_96547_, "dialog.text", this.leftPos + 10, this.topPos + 34, 0);
        for (int i = 1; i <= 6; ++i) {
            Text.drawString(poseStack, this.f_96547_, i + ":", this.leftPos + 10, this.topPos + 35 + i * 20, 0);
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderEditLabels(poseStack);
    }
}

