/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.action.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.editor.action.ActionDataEntryEditorContainerScreen;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.ActionEntryWidget;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;

public class OpenNamedDialogEntry
extends ActionEntryWidget {
    private final DialogDataSet dialogDataSet;
    private TextField dialogNameTextField;
    private boolean showInvalidDialogName = false;

    public OpenNamedDialogEntry(ActionDataEntry actionDataEntry, ActionDataSet actionDataSet, ActionDataEntryEditorContainerScreen<?> screen) {
        super(actionDataEntry, actionDataSet, screen);
        this.dialogDataSet = screen.getDialogDataSet();
    }

    private void validateDialogName(String dialogName) {
        if (dialogName == null || dialogName.isEmpty()) {
            return;
        }
        this.showInvalidDialogName = this.dialogDataSet == null || !this.dialogDataSet.hasDialog(dialogName);
    }

    @Override
    public void init(int editorLeft, int editorTop) {
        boolean hasActionData = this.hasActionData(ActionDataType.OPEN_NAMED_DIALOG);
        this.dialogNameTextField = this.screen.addActionEntryWidget(new TextField(this.font, editorLeft, editorTop + 20, 275, 16));
        this.dialogNameTextField.m_94199_(512);
        this.dialogNameTextField.m_94144_(hasActionData ? this.actionDataEntry.command() : "");
        this.dialogNameTextField.m_94151_(this::validateDialogName);
    }

    @Override
    public void render(PoseStack poseStack, int editorLeft, int editorTop) {
        Text.drawString(poseStack, this.font, "Named Dialog", editorLeft + 2, editorTop + 5, 0x404040);
        if (this.showInvalidDialogName) {
            Text.drawString(poseStack, this.font, "Invalid Dialog Name", editorLeft + 2, editorTop + 40, 0xFF5555);
        }
    }

    @Override
    public ActionDataEntry getActionDataEntry() {
        return new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, this.dialogNameTextField.m_94155_());
    }

    @Override
    public boolean hasChanged() {
        return this.dialogNameTextField != null && !this.dialogNameTextField.m_94155_().equals(this.actionDataEntry.command()) && !this.showInvalidDialogName;
    }
}

