/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.action;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.ActionButton;
import de.markusbordihn.easynpc.client.screen.components.ActionsButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.ActionEntryWidget;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.CloseDialogEntry;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.CommandActionEntry;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.InteractBlockEntry;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.OpenDefaultDialogEntry;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.OpenNamedDialogEntry;
import de.markusbordihn.easynpc.client.screen.editor.action.entry.OpenTradingScreenEntry;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ActionDataEntryEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ActionDataEntry actionDataEntry;
    private final ActionDataSet actionDataSet;
    private final ActionEventType actionEventType = this.getAdditionalScreenData().getActionEventType();
    private final ConfigurationType configurationType = this.getAdditionalScreenData().getConfigurationType();
    private final EditorType editorType = this.getAdditionalScreenData().getEditorType();
    private final UUID actionDataEntryId;
    protected Button actionDataTypeButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected Button homeButton;
    protected Button saveButton;
    protected Button navigationLevelOne;
    protected Button navigationLevelTwo;
    protected int contentTop;
    private ActionEntryWidget actionEntryWidget;
    private ActionDataType actionDataType;

    public ActionDataEntryEditorContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.actionDataSet = this.getActionDataSet();
        this.actionDataEntryId = this.getActionDataEntryUUID();
        this.actionDataEntry = this.getActionDataEntry();
        this.actionDataType = this.actionDataEntry.actionDataType() != ActionDataType.NONE ? this.actionDataEntry.actionDataType() : ActionDataType.COMMAND;
    }

    private ActionDataSet getActionDataSet() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            return this.getAdditionalScreenData().getActionEventSet().getActionEvents(this.actionEventType);
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            return this.getDialogButtonData().actionDataSet();
        }
        log.error("No valid action data set found for {}!", (Object)this.getEasyNPCUUID());
        return new ActionDataSet();
    }

    private ActionDataEntry getActionDataEntry() {
        if (this.actionDataSet != null && this.actionDataEntryId != null && this.actionDataSet.contains(this.actionDataEntryId)) {
            return this.actionDataSet.getEntryOrDefault(this.actionDataEntryId);
        }
        if (this.actionDataSet != null && this.actionDataEntryId != null) {
            log.error("No valid action data entry found for {} in {}!", (Object)this.actionDataEntryId, (Object)this.actionDataSet);
        }
        return new ActionDataEntry();
    }

    private void navigateToActionDataEditor() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid action event type found for {}!", (Object)this.getEasyNPCUUID());
        }
    }

    private void saveActionDataEntry() {
        if (this.actionDataSet == null) {
            return;
        }
        ActionDataEntry newActionDataEntry = this.actionEntryWidget != null ? this.actionEntryWidget.getActionDataEntry() : new ActionDataEntry();
        this.actionDataSet.put(this.actionDataEntryId, newActionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to save Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
    }

    private void deleteActionDataEntry() {
        if (this.f_96541_ == null || this.actionDataSet == null || this.actionDataEntryId == null || this.actionDataEntryId == Constants.EMPTY_UUID) {
            return;
        }
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.actionDataSet.remove(this.actionDataEntryId);
                if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
                    NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
                } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
                    NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
                } else {
                    log.error("Unable to delete Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
                }
                this.navigateToActionDataEditor();
            } else {
                this.f_96541_.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedText("removeActionDataEntry.deleteQuestion"), (Component)TextComponent.getTranslatedText("removeActionDataEntry.deleteWarning", this.actionDataEntry.actionDataType().name()), (Component)TextComponent.getTranslatedText("removeActionDataEntry.deleteButton"), CommonComponents.f_130656_));
    }

    protected void changeActionDataType(SpinButton<?> spinButton) {
        log.info("Change action data type to {}", spinButton.get());
        this.actionDataType = (ActionDataType)((Object)spinButton.get());
        this.m_169413_();
        this.m_7856_();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.contentTop = this.topPos + 20;
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 18, "<", onPress -> this.navigateToActionDataEditor()));
        this.navigationLevelOne = (Button)this.m_142416_((GuiEventListener)new ActionsButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
        int actionDataEntryPosition = this.actionDataSet.getPosition(this.actionDataEntry);
        this.navigationLevelTwo = (Button)this.m_142416_((GuiEventListener)new ActionButton(this.navigationLevelOne.f_93620_ + this.navigationLevelOne.m_5711_(), this.topPos + 3, 140, (String)(actionDataEntryPosition == -1 ? "Action: New" : "Action: " + this.actionDataSet.getPosition(this.actionDataEntry)), onPress -> this.navigateToActionDataEditor()));
        this.navigationLevelTwo.f_93623_ = false;
        this.actionDataTypeButton = (Button)this.m_142416_((GuiEventListener)new SpinButton<ActionDataType>(this.leftPos + 120, this.contentTop + 5, 150, 16, Arrays.stream(ActionDataType.values()).filter(type -> type != ActionDataType.NONE).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), this.actionDataType, this::changeActionDataType));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveActionDataEntry();
            this.navigateToActionDataEditor();
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.saveButton.f_93620_ + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, onPress -> this.deleteActionDataEntry()));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.deleteButton.f_93620_ + this.deleteButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.navigateToActionDataEditor()));
        switch (this.actionDataType) {
            case CLOSE_DIALOG: {
                this.actionEntryWidget = new CloseDialogEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case COMMAND: {
                this.actionEntryWidget = new CommandActionEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case INTERACT_BLOCK: {
                this.actionEntryWidget = new InteractBlockEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case OPEN_DEFAULT_DIALOG: {
                this.actionEntryWidget = new OpenDefaultDialogEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case OPEN_NAMED_DIALOG: {
                this.actionEntryWidget = new OpenNamedDialogEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case OPEN_TRADING_SCREEN: {
                this.actionEntryWidget = new OpenTradingScreenEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            default: {
                this.actionEntryWidget = null;
                log.error("Unsupported action data type {}!", (Object)this.actionDataType);
            }
        }
        int editorLeft = this.leftPos + 10;
        int editorTop = this.contentTop + 25;
        if (this.actionEntryWidget != null) {
            this.actionEntryWidget.init(editorLeft, editorTop);
        }
    }

    public <W extends GuiEventListener & Widget> W addActionEntryWidget(W widget) {
        return (W)this.m_142416_(widget);
    }

    public Font getFont() {
        return this.f_96547_;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        int editorLeft = this.leftPos + 10;
        int editorTop = this.contentTop + 25;
        Text.drawString(poseStack, this.f_96547_, "Action Data Type:", this.leftPos + 10, this.topPos + 30, 0);
        if (this.actionEntryWidget != null) {
            this.actionEntryWidget.render(poseStack, editorLeft, editorTop);
        }
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = this.actionDataType != this.actionDataEntry.actionDataType() && this.actionDataEntry.actionDataType() != ActionDataType.NONE || this.actionEntryWidget != null && this.actionEntryWidget.hasChanged();
        }
        if (this.deleteButton != null) {
            this.deleteButton.f_93623_ = this.actionDataSet != null && this.actionDataEntry != null && this.actionDataEntry.isValidAndNotEmpty() && this.actionDataEntryId != null && this.actionDataEntryId != Constants.EMPTY_UUID;
        }
    }
}

