/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.action;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.ActionsButton;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.editor.action.ActionDataList;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ActionDataEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ActionDataSet actionDataSet;
    private final ActionEventType actionEventType = this.getAdditionalScreenData().getActionEventType();
    private final ConfigurationType configurationType = this.getAdditionalScreenData().getConfigurationType();
    private final EditorType editorType = this.getAdditionalScreenData().getEditorType();
    protected Button homeButton;
    protected Button navigationLevelOne;
    protected Button navigationLevelTwo;
    protected Button newActionDataEntryButton;
    ActionDataList actionDataList;

    public ActionDataEditorContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.actionDataSet = this.getActionDataSet();
    }

    private ActionDataSet getActionDataSet() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            return this.getAdditionalScreenData().getActionEventSet().getActionEvents(this.actionEventType);
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            return this.getDialogButtonData().actionDataSet();
        }
        log.error("No valid action data set found!");
        return null;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 18, "<", onPress -> this.handleBackNavigation()));
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.navigationLevelOne = (Button)this.m_142416_((GuiEventListener)new ActionsButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.topPos + 3, 140, this.actionEventType.name(), onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.f_93623_ = false;
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.navigationLevelOne = (Button)this.m_142416_((GuiEventListener)new DialogButtonButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.topPos + 3, 140, this.getDialogButtonData().getButtonName(21).getString(), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID())));
        } else {
            this.navigationLevelOne = (Button)this.m_142416_((GuiEventListener)new ActionsButton(this.homeButton.f_93620_ + this.homeButton.m_5711_(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.f_93623_ = false;
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.navigationLevelTwo = (Button)this.m_142416_((GuiEventListener)new ActionsButton(this.navigationLevelOne.f_93620_ + this.navigationLevelOne.m_5711_(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelTwo.f_93623_ = false;
        }
        this.newActionDataEntryButton = (Button)this.m_142416_((GuiEventListener)new AddButton(this.leftPos + 7, this.topPos + 210, 300, "action.add", onPress -> this.handleNewActionDataEntry()));
        this.actionDataList = new ActionDataList(this.actionDataSet, this.f_96541_, this.f_96543_ + 50, this.f_96544_ - 60, this.leftPos + 5, this.topPos + 40, this.topPos + 200, 21, this::handleMoveUpOrderActionDataEntry, this::handleMoveDownOrderActionDataEntry, this::handleEditActionDataEntry, this::handleDeleteActionDataEntry);
        this.m_7787_((GuiEventListener)this.actionDataList);
    }

    private void navigateToActionDataEditor() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON && this.getDialogUUID() != null && this.getDialogButtonUUID() != null) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleBackNavigation() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON && this.getDialogUUID() != null && this.getDialogButtonUUID() != null) {
            NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid back navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleNewActionDataEntry() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, new ActionDataEntry());
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), new ActionDataEntry());
        } else {
            log.error("No valid new action data entry found!");
        }
    }

    private void handleDeleteActionDataEntry(ActionDataEntry actionDataEntry) {
        if (this.f_96541_ == null || this.actionDataSet == null || actionDataEntry == null || actionDataEntry.getId() == Constants.EMPTY_UUID) {
            return;
        }
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.actionDataSet.remove(actionDataEntry.getId());
                if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
                    NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
                } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
                    NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
                } else {
                    log.error("Unable to delete Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
                }
                this.navigateToActionDataEditor();
            } else {
                this.f_96541_.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedText("removeActionDataEntry.deleteQuestion"), (Component)TextComponent.getTranslatedText("removeActionDataEntry.deleteWarning", actionDataEntry.actionDataType().name()), (Component)TextComponent.getTranslatedText("removeActionDataEntry.deleteButton"), CommonComponents.f_130656_));
    }

    private void handleEditActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Editing Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, actionDataEntry);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), actionDataEntry);
        } else {
            log.error("Unable to edit action data entry {}!", (Object)actionDataEntry);
        }
    }

    private void handleMoveUpOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving up Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.actionDataSet.moveUp(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.actionDataSet.moveUp(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to move up Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
        this.navigateToActionDataEditor();
    }

    private void handleMoveDownOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving down Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.actionDataSet.moveDown(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.actionDataSet.moveDown(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to move down Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
        this.navigateToActionDataEditor();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        ActionDataEditorContainerScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 5), (int)(this.topPos + 30), (int)(this.leftPos + 314), (int)(this.topPos + 200), (int)-1118482);
        if (this.actionDataList != null) {
            this.actionDataList.m_6305_(poseStack, x, y, partialTicks);
        }
        this.renderHeader(poseStack);
        this.renderFooter(poseStack);
        if (this.newActionDataEntryButton != null) {
            this.newActionDataEntryButton.m_6305_(poseStack, x, y, partialTicks);
        }
    }

    private void renderHeader(PoseStack poseStack) {
        ActionDataEditorContainerScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 5), (int)(this.topPos + 25), (int)(this.leftPos + 314), (int)(this.topPos + 43), (int)-5592406);
        int headerLeft = this.leftPos + 10;
        int headerTop = this.topPos + 30;
        Text.drawString(poseStack, this.f_96547_, "ID", headerLeft + 0, headerTop, 0);
        Text.drawConfigString(poseStack, this.f_96547_, "type", headerLeft + 22, headerTop, 0);
        Text.drawConfigString(poseStack, this.f_96547_, "value", headerLeft + 130, headerTop, 0);
        Text.drawString(poseStack, this.f_96547_, "Action", headerLeft + 230, headerTop, 0);
        int separatorTop = headerTop - 5;
        ActionDataEditorContainerScreen.m_93172_((PoseStack)poseStack, (int)(headerLeft + 22 - 3), (int)separatorTop, (int)(headerLeft + 22 - 2), (int)(separatorTop + 18), (int)-10066330);
        ActionDataEditorContainerScreen.m_93172_((PoseStack)poseStack, (int)(headerLeft + 130 - 3), (int)separatorTop, (int)(headerLeft + 130 - 2), (int)(separatorTop + 18), (int)-10066330);
        ActionDataEditorContainerScreen.m_93172_((PoseStack)poseStack, (int)(headerLeft + 230 - 3), (int)separatorTop, (int)(headerLeft + 230 - 2), (int)(separatorTop + 18), (int)-10066330);
    }

    private void renderFooter(PoseStack poseStack) {
        ActionDataEditorContainerScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 5), (int)(this.topPos + 200), (int)(this.leftPos + 314), (int)(this.topPos + 231), (int)-3750202);
    }
}

