/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.trading;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class BasicTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    protected EditBox resetsEveryMinEditBox;
    protected EditBox maxUsesEditBox;
    protected EditBox rewardExpEditBox;

    public BasicTradingConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero(text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingResetsEveryMin(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero(text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingMaxUses(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onRewardExpEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero(text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingRewardExp(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.basicTradesButton.f_93623_ = false;
        TradingData<?> tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        this.resetsEveryMinEditBox = new TextField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 142, 32);
        this.resetsEveryMinEditBox.m_94199_(3);
        this.resetsEveryMinEditBox.m_94144_("" + tradingDataSet.getResetsEveryMin());
        this.resetsEveryMinEditBox.m_94151_(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.m_94153_(ValueUtils::isPositiveNumericValueOrZero);
        this.m_142416_((GuiEventListener)this.resetsEveryMinEditBox);
        this.maxUsesEditBox = new PositiveNumberField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 165, 32);
        this.maxUsesEditBox.m_94199_(4);
        this.maxUsesEditBox.m_94144_("" + tradingDataSet.getMaxUses());
        this.maxUsesEditBox.m_94151_(this::onMaxUsesEditBoxChanged);
        this.maxUsesEditBox.m_94153_(ValueUtils::isPositiveNumericValueOrZero);
        this.m_142416_((GuiEventListener)this.maxUsesEditBox);
        this.rewardExpEditBox = new TextField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 188, 32);
        this.rewardExpEditBox.m_94199_(3);
        this.rewardExpEditBox.m_94144_("" + tradingDataSet.getRewardedXP());
        this.rewardExpEditBox.m_94151_(this::onRewardExpEditBoxChanged);
        this.rewardExpEditBox.m_94153_(ValueUtils::isPositiveNumericValueOrZero);
        this.m_142416_((GuiEventListener)this.rewardExpEditBox);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.m_7025_(poseStack, x, y);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int slotPositionX = this.f_97735_ + 30 - 1;
        int slotPositionY = this.f_97736_ + 40 - 1;
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            if (tradingOffer == 6) {
                slotPositionX = this.f_97735_ + 190 - 1;
                slotPositionY = this.f_97736_ + 40 - 1;
            }
            Text.drawString(poseStack, this.f_96547_, (tradingOffer < 9 ? " " : "") + (tradingOffer + 1) + ".", slotPositionX - 15, slotPositionY + 5, 0x404040);
            int itemASlotLeftPosition = slotPositionX;
            int itemASlotTopPosition = slotPositionY;
            Graphics.blit(poseStack, Constants.TEXTURE_INVENTORY, itemASlotLeftPosition, itemASlotTopPosition, 7, 7, 18, 18);
            Text.drawString(poseStack, this.f_96547_, "+", itemASlotLeftPosition + 18 + 6, itemASlotTopPosition + 5, 0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            Graphics.blit(poseStack, Constants.TEXTURE_INVENTORY, itemBSlotLeftPosition, itemBSlotTopPosition, 7, 7, 18, 18);
            Text.drawString(poseStack, this.f_96547_, "=", itemBSlotLeftPosition + 18 + 12, itemBSlotTopPosition + 5, 0x404040);
            Graphics.blit(poseStack, Constants.TEXTURE_INVENTORY, slotPositionX + 82, slotPositionY, 7, 7, 18, 18);
            slotPositionY += 19;
        }
        Graphics.blit(poseStack, Constants.TEXTURE_INVENTORY, this.contentLeftPos, this.contentTopPos + 135, 7, 83, 162, 54);
        Graphics.blit(poseStack, Constants.TEXTURE_INVENTORY, this.contentLeftPos, this.contentTopPos + 191, 7, 141, 162, 18);
        Text.drawConfigString(poseStack, this.f_96547_, "trading.minutes_for_trade_reset", this.contentLeftPos + 202, this.resetsEveryMinEditBox.f_93621_ + 3, 0x404040);
        Text.drawConfigString(poseStack, this.f_96547_, "trading.max_uses_per_trade", this.contentLeftPos + 202, this.maxUsesEditBox.f_93621_ + 3, 0x404040);
        Text.drawConfigString(poseStack, this.f_96547_, "trading.rewarded_exp_per_trade", this.contentLeftPos + 202, this.rewardExpEditBox.f_93621_ + 3, 0x404040);
    }
}

