/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class SkinConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static final int SKIN_PREVIEW_WIDTH = 60;
    protected static int nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond();
    protected static int nextSkinReload = (int)Instant.now().getEpochSecond();
    protected Button noneSkinButton = null;
    protected Button customSkinButton = null;
    protected Button defaultSkinButton = null;
    protected Button playerSkinButton = null;
    protected Button urlSkinButton = null;
    protected Button skinPreviousButton = null;
    protected Button skinNextButton = null;
    protected Button skinPreviousPageButton = null;
    protected Button skinNextPageButton = null;
    protected int skinStartIndex = 0;
    protected int numOfSkins = 0;
    protected int maxSkinsPerPage = 5;
    protected int lastNumOfSkins = 0;
    protected List<Button> skinButtons = new ArrayList<Button>();

    public SkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void checkSkinNavigationButtonState() {
        if (this.skinPreviousButton != null) {
            boolean bl = this.skinPreviousButton.f_93623_ = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl = this.skinNextButton.f_93623_ = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl = this.skinPreviousPageButton.f_93623_ = this.skinStartIndex - this.maxSkinsPerPage > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.f_93623_ = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
        }
    }

    protected void renderSkinSelectionBackground(PoseStack poseStack) {
        SkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(this.contentTopPos + 104), (int)(this.contentLeftPos + 302), (int)(this.contentTopPos + 190), (int)-16777216);
        SkinConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 105), (int)(this.contentLeftPos + 301), (int)(this.contentTopPos + 189), (int)-5592406);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.noneSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, 44, "disable_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN)));
        this.defaultSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.noneSkinButton.f_93620_ + this.noneSkinButton.m_5711_(), this.buttonTopPos, 64, "default", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN)));
        this.playerSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.defaultSkinButton.f_93620_ + this.defaultSkinButton.m_5711_(), this.buttonTopPos, 62, "player_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN)));
        this.urlSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.playerSkinButton.f_93620_ + this.playerSkinButton.m_5711_(), this.buttonTopPos, 40, "url_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN)));
        this.customSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.urlSkinButton.f_93620_ + this.urlSkinButton.m_5711_(), this.buttonTopPos, 80, "custom", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN)));
        TextureManager.clearLastErrorMessage();
        this.checkAccess();
        ConfigurationData<?> configurationData = this.getEasyNPC().getEasyNPCConfigurationData();
        if (!configurationData.supportsPlayerSkinConfiguration()) {
            this.urlSkinButton.f_93620_ = this.defaultSkinButton.f_93620_ + this.defaultSkinButton.m_5711_();
            this.customSkinButton.f_93620_ = this.urlSkinButton.f_93620_ + this.urlSkinButton.m_5711_();
            this.playerSkinButton.f_93624_ = false;
        }
    }

    private void checkAccess() {
        ConfigurationData<?> configurationData = this.getEasyNPC().getEasyNPCConfigurationData();
        this.customSkinButton.f_93623_ = this.customSkinButton.f_93623_ && configurationData.supportsSkinConfiguration() && configurationData.supportsCustomSkinConfiguration();
        this.defaultSkinButton.f_93623_ = this.defaultSkinButton.f_93623_ && configurationData.supportsSkinConfiguration() && configurationData.supportsDefaultSkinConfiguration();
        this.noneSkinButton.f_93623_ = this.noneSkinButton.f_93623_ && configurationData.supportsSkinConfiguration() && configurationData.supportsNoneSkinConfiguration();
        this.playerSkinButton.f_93623_ = this.playerSkinButton.f_93623_ && configurationData.supportsSkinConfiguration() && configurationData.supportsPlayerSkinConfiguration();
        this.urlSkinButton.f_93623_ = this.urlSkinButton.f_93623_ && configurationData.supportsSkinConfiguration() && configurationData.supportsUrlSkinConfiguration();
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(poseStack);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void defineSkinNavigationButtons() {
        this.defineSkinNavigationButtons(this.contentTopPos + 189, this.contentLeftPos, this.rightPos - 29);
    }

    protected void defineSkinNavigationButtons(int skinButtonTop, int skinButtonLeft, int skinButtonRight) {
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - this.maxSkinsPerPage, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_6305_(poseStack, x, y, partialTicks);
            }
        }
    }
}

