/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.validator.NameValidator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class PlayerSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_DELAY = 20;
    protected Button addTextureSettingsButton = null;
    protected EditBox textureSkinLocationBox;
    private boolean canTextureSkinLocationChange = true;
    private Button clearTextureSettingsButton = null;
    private String formerTextureSkinLocation = "";
    private String errorMessage = "";

    public PlayerSkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void renderSkins(PoseStack poseStack) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set<UUID> textures = PlayerTextureManager.getTextureCacheKeys(skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(left, top, skinModel, textureKey);
            int topNamePos = Math.round((float)(top - 76) / 0.7f);
            int leftNamePos = Math.round((float)(left - 21) / 0.7f);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 100.0);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            Text.drawString(poseStack, this.f_96547_, variantName, leftNamePos, topNamePos, 43520);
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        SkinType skinType = PlayerTextureManager.getTextureSkinType(textureModelKey);
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setPlayerSkin(this.getEasyNPCUUID(), "", textureUUID));
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.f_93623_ = !skinUUID.equals(textureUUID);
        ScreenHelper.renderEntityCustomSkin(x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), textureUUID, skinType);
        this.skinButtons.add(skinButton);
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.m_94155_().isEmpty()) {
            this.textureSkinLocationBox.m_94144_("");
        }
    }

    private void addTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (!textureSkinLocationValue.isEmpty() && !textureSkinLocationValue.equals(this.formerTextureSkinLocation)) {
            if (!NameValidator.isValidPlayerName(textureSkinLocationValue)) {
                this.errorMessage = "invalid_player_name";
                return;
            }
            UUID playerUUID = PlayersUtils.getUserUUID(textureSkinLocationValue);
            if (playerUUID == null) {
                this.errorMessage = "invalid_player_uuid";
                return;
            }
            log.debug("Setting player texture to {} with UUID {}", (Object)textureSkinLocationValue, (Object)playerUUID);
            TextureManager.clearLastErrorMessage();
            this.errorMessage = "";
            NetworkMessageHandlerManager.getServerHandler().setPlayerSkin(this.getEasyNPCUUID(), textureSkinLocationValue, playerUUID);
            this.addTextureSettingsButton.f_93623_ = false;
            this.formerTextureSkinLocation = textureSkinLocationValue;
            PlayerSkinConfigurationScreen.updateNextTextureSkinLocationChange();
        }
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (!this.canTextureSkinLocationChange) {
            this.addTextureSettingsButton.f_93623_ = false;
            this.clearTextureSettingsButton.f_93623_ = true;
            return;
        }
        this.addTextureSettingsButton.f_93623_ = !textureSkinLocationValue.isEmpty() && NameValidator.isValidPlayerName(textureSkinLocationValue);
        this.clearTextureSettingsButton.f_93623_ = !textureSkinLocationValue.isEmpty();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.playerSkinButton.f_93623_ = false;
        this.setDescriptionText("player_skin.text");
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = PlayerTextureManager.getTextureCacheKeys(skinModel).size();
        this.textureSkinLocationBox = new TextField(this.f_96547_, this.contentLeftPos, this.contentTopPos + 50, 180);
        this.textureSkinLocationBox.m_94199_(255);
        this.textureSkinLocationBox.m_94144_("");
        this.textureSkinLocationBox.m_94151_(consumer -> this.validateTextureSkinLocation());
        this.m_142416_((GuiEventListener)this.textureSkinLocationBox);
        this.addTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.textureSkinLocationBox.f_93620_ + this.textureSkinLocationBox.m_5711_() + 2, this.contentTopPos + 50, 65, "add", onPress -> this.addTextureSkinLocation()));
        this.addTextureSettingsButton.f_93623_ = false;
        this.clearTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.addTextureSettingsButton.f_93620_ + this.addTextureSettingsButton.m_5711_() + 1, this.contentTopPos + 50, 55, "clear", onPress -> this.clearTextureSkinLocation()));
        this.clearTextureSettingsButton.f_93623_ = false;
        this.defineSkinNavigationButtons();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderDescriptionText(poseStack, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.addTextureSettingsButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "use_a_player_name", this.contentLeftPos, this.addTextureSettingsButton.f_93621_ - 10);
        }
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        if (!this.canTextureSkinLocationChange) {
            poseStack.m_85837_(0.0, 0.0, 100.0);
            Graphics.blit(poseStack, Constants.TEXTURE_CONFIGURATION, this.leftPos + 176, this.contentTopPos + 53, 82, 1, 8, 10);
            if (!TextureManager.hasLastErrorMessage() && this.errorMessage.isEmpty()) {
                Text.drawConfigString(poseStack, this.f_96547_, "processing_url_skin", this.leftPos + 55, this.contentTopPos + 80);
            }
        }
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            Text.drawErrorMessage(poseStack, this.f_96547_, (Component)TextComponent.getTranslatedText(this.errorMessage), this.leftPos + 10, this.contentTopPos + 71, this.imageWidth - 14);
        } else if (TextureManager.hasLastErrorMessage()) {
            Text.drawErrorMessage(poseStack, this.f_96547_, TextureManager.getLastErrorMessage(), this.leftPos + 10, this.contentTopPos + 71, this.imageWidth - 14);
        }
        this.renderSkins(poseStack);
    }
}

