/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.scaling;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScalingConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    private static final int DIMENSION_UPDATE_TICK = 20;
    protected Button defaultScaleButton;
    protected Button defaultScaleXButton;
    protected Button defaultScaleYButton;
    protected Button defaultScaleZButton;
    protected RangeSliderButton scaleXSliderButton;
    protected RangeSliderButton scaleYSliderButton;
    protected RangeSliderButton scaleZSliderButton;
    private int dimensionUpdateTicker = 0;

    public ScalingConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        this.defaultScaleButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "scaling", button -> {}));
        this.defaultScaleButton.f_93623_ = false;
        int scalePositionLeft = this.contentLeftPos + 165;
        int scalePositionTop = this.contentTopPos + 20;
        int scalePositionSpace = 60;
        int scaleWidth = 140;
        int scaleHeight = 20;
        ScaleData<?> scaleData = this.getEasyNPC().getEasyNPCScaleData();
        this.scaleXSliderButton = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(scalePositionLeft, scalePositionTop, scaleWidth, scaleHeight, scaleData.getScaleX().floatValue(), scaleData.getDefaultScaleX().floatValue(), SliderButton.Type.SCALE, slider -> {
            float scale = slider.getTargetValue();
            if (scaleData.getScaleX().floatValue() != scale) {
                NetworkMessageHandlerManager.getServerHandler().scaleChange(this.getEasyNPCUUID(), ModelScaleAxis.X, slider.getTargetValue());
            }
        }));
        this.scaleYSliderButton = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(scalePositionLeft, scalePositionTop + scalePositionSpace, scaleWidth, scaleHeight, scaleData.getScaleY().floatValue(), scaleData.getDefaultScaleY().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (scaleData.getScaleY().floatValue() != scale) {
                NetworkMessageHandlerManager.getServerHandler().scaleChange(this.getEasyNPCUUID(), ModelScaleAxis.Y, button.getTargetValue());
            }
        }));
        this.scaleZSliderButton = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(scalePositionLeft, scalePositionTop + scalePositionSpace * 2, scaleWidth, scaleHeight, scaleData.getScaleZ().floatValue(), scaleData.getDefaultScaleZ().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (scaleData.getScaleZ().floatValue() != scale) {
                NetworkMessageHandlerManager.getServerHandler().scaleChange(this.getEasyNPCUUID(), ModelScaleAxis.Z, button.getTargetValue());
            }
        }));
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.getEasyNPCEntity() != null && this.dimensionUpdateTicker++ > 20) {
            this.getEasyNPCEntity().m_6210_();
            this.dimensionUpdateTicker = 0;
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        ScreenHelper.renderEntityAvatarForScaling(this.contentLeftPos + 80, this.contentTopPos + 192, 30, (float)(this.contentLeftPos + 75) - this.xMouse, (float)(this.contentTopPos + 120) - this.yMouse, this.getEasyNPC());
        Text.drawConfigString(poseStack, this.f_96547_, "scale_x", this.scaleXSliderButton.f_93620_, this.scaleXSliderButton.f_93621_ - 10);
        Text.drawConfigString(poseStack, this.f_96547_, "scale_y", this.scaleYSliderButton.f_93620_, this.scaleYSliderButton.f_93621_ - 10);
        Text.drawConfigString(poseStack, this.f_96547_, "scale_z", this.scaleZSliderButton.f_93620_, this.scaleZSliderButton.f_93621_ - 10);
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        String[] scaleValues;
        super.renderBg(poseStack, partialTicks, mouseX, mouseY);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.contentTopPos, (int)(this.contentLeftPos + 159), (int)(this.contentTopPos + 207), (int)-16777216);
        ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 158), (int)(this.contentTopPos + 206), (int)-5592406);
        int scaleLinesColor = -1437248171;
        int scaleLinesTop = this.contentTopPos + 193;
        int scaleLinesLeft = this.contentLeftPos + 4;
        for (String scaleValue : scaleValues = new String[]{"  0", "0.5", "1.0", "1.5", "2.0", "2.5", "3.0"}) {
            Text.drawString(poseStack, this.f_96547_, scaleValue, scaleLinesLeft, scaleLinesTop - 4, scaleLinesColor);
            ScalingConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 20), (int)(scaleLinesTop - 1), (int)(this.contentLeftPos + 152), (int)scaleLinesTop, (int)scaleLinesColor);
            scaleLinesTop -= 31;
        }
    }
}

