/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.preset.ExportPresetConfigurationScreen;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class ExportCustomPresetConfigurationScreen<T extends ConfigurationMenu>
extends ExportPresetConfigurationScreen<T> {
    protected Button exportPresetButton;
    protected Button openCustomExportPresetFolder;
    protected int numberOfTextLines = 1;
    private File customPresetFile;
    private String customPresetFileName = "";
    private EditBox nameBox;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public ExportCustomPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void validateName() {
        String nameValue = this.nameBox.m_94155_();
        this.exportPresetButton.f_93623_ = !nameValue.isEmpty();
        this.customPresetFileName = nameValue;
        this.textComponents = this.f_96547_.m_92923_((FormattedText)TextComponent.getTranslatedConfigText("export_preset_text", this.customPresetFile.getParentFile().getPath(), this.customPresetFileName), this.imageWidth - 25);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customExportPresetButton.f_93623_ = false;
        this.customPresetFile = CustomPresetDataFiles.getPresetFile(this.getSkinModel(), this.getEasyNPCUUID());
        this.customPresetFileName = this.customPresetFile.getName();
        this.nameBox = new TextField(this.f_96547_, this.contentLeftPos + 5, this.bottomPos - 65, 270);
        this.nameBox.m_94199_(64);
        this.nameBox.m_94144_(this.customPresetFileName);
        this.nameBox.m_94151_(consumer -> this.validateName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.textComponents = this.f_96547_.m_92923_((FormattedText)TextComponent.getTranslatedConfigText("export_preset_text", this.customPresetFile.getParentFile().getPath(), this.customPresetFile.getName()), this.imageWidth - 25);
        this.numberOfTextLines = this.textComponents.size();
        this.openCustomExportPresetFolder = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 5, this.bottomPos - 95, 275, "open_custom_export_preset_folder", button -> Util.m_137581_().m_137644_(this.customPresetFile.getParentFile())));
        this.exportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 65, this.bottomPos - 40, 150, "export", button -> {
            NetworkMessageHandlerManager.getServerHandler().exportPreset(this.getEasyNPCUUID(), this.nameBox.m_94155_());
            this.exportPresetButton.f_93623_ = false;
        }));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(poseStack, this.f_96547_, formattedCharSequence, this.leftPos + 15, this.topPos + 45 + line * (9 + 2));
            }
        }
    }
}

