/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class PoseConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected final ModelData<?> modelData = this.getEasyNPC().getEasyNPCModelData();
    protected Button defaultPoseButton;
    protected Button advancedPoseButton;
    protected Button customPoseButton;

    public PoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected RangeSliderButton createRotationSlider(int left, int top, ModelPart modelPart, String label) {
        int sliderWidth = 34;
        int sliderHeight = 16;
        int sliderLeftPosition = left + 10;
        CustomRotation modelPartRotation = this.modelData.getModelPartRotation(modelPart);
        RangeSliderButton sliderButtonX = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(sliderLeftPosition, top, sliderWidth, sliderHeight, Math.toDegrees(modelPartRotation.x()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation((float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.y(), currentModelPartRotation.z()));
        }));
        RangeSliderButton sliderButtonY = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(sliderButtonX.f_93620_ + sliderButtonX.m_5711_(), top, sliderWidth, sliderHeight, Math.toDegrees(modelPartRotation.y()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(currentModelPartRotation.x(), (float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.z()));
        }));
        RangeSliderButton sliderButtonZ = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(sliderButtonY.f_93620_ + sliderButtonY.m_5711_(), top, sliderWidth, sliderHeight, Math.toDegrees(modelPartRotation.z()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(currentModelPartRotation.x(), currentModelPartRotation.y(), (float)Math.toRadians(slider.getTargetValue())));
        }));
        this.m_142416_((GuiEventListener)new TextButton(left, top, 10, RangeSliderButton.EDIT_TEXT, button -> {
            if (button.m_6035_() == RangeSliderButton.EDIT_TEXT) {
                sliderButtonX.showTextField();
                sliderButtonY.showTextField();
                sliderButtonZ.showTextField();
                button.m_93666_(RangeSliderButton.DONE_TEXT);
            } else {
                sliderButtonX.showSliderButton();
                sliderButtonY.showSliderButton();
                sliderButtonZ.showSliderButton();
                button.m_93666_(RangeSliderButton.EDIT_TEXT);
            }
        }));
        int resetButtonLeftPosition = sliderButtonZ.f_93620_ + sliderButtonZ.m_5711_();
        this.m_142416_((GuiEventListener)new TextButton(resetButtonLeftPosition, top, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            sliderButtonX.reset();
            sliderButtonY.reset();
            sliderButtonZ.reset();
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(0.0f, 0.0f, 0.0f));
        }));
        return sliderButtonX;
    }

    protected RangeSliderButton createPositionSliderCompact(int left, int top, ModelPart modelPart, String label) {
        return this.createPositionSlider(left, top, modelPart, label, true);
    }

    protected RangeSliderButton createPositionSlider(int left, int top, ModelPart modelPart, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderHeight = 16;
        int sliderLeftPosition = left + 10;
        CustomPosition modelPartPosition = this.modelData.getModelPartPosition(modelPart);
        RangeSliderButton sliderButtonX = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(sliderLeftPosition, top, sliderWidth, sliderHeight, (double)modelPartPosition.x(), 0.0, SliderButton.Type.POSITION, false, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(slider.getTargetValue(), currentModelPartPosition.y(), currentModelPartPosition.z()));
        }));
        RangeSliderButton sliderButtonY = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(sliderButtonX.f_93620_ + sliderButtonX.m_5711_(), top, sliderWidth, sliderHeight, (double)modelPartPosition.y(), 0.0, SliderButton.Type.POSITION, false, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(currentModelPartPosition.x(), slider.getTargetValue(), currentModelPartPosition.z()));
        }));
        RangeSliderButton sliderButtonZ = (RangeSliderButton)this.m_142416_((GuiEventListener)new RangeSliderButton(sliderButtonY.f_93620_ + sliderButtonY.m_5711_(), top, sliderWidth, sliderHeight, (double)modelPartPosition.z(), 0.0, SliderButton.Type.POSITION, false, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(currentModelPartPosition.x(), currentModelPartPosition.y(), slider.getTargetValue()));
        }));
        this.m_142416_((GuiEventListener)new TextButton(left, top, 10, RangeSliderButton.EDIT_TEXT, button -> {
            if (button.m_6035_() == RangeSliderButton.EDIT_TEXT) {
                sliderButtonX.showTextField();
                sliderButtonY.showTextField();
                sliderButtonZ.showTextField();
                button.m_93666_(RangeSliderButton.DONE_TEXT);
            } else {
                sliderButtonX.showSliderButton();
                sliderButtonY.showSliderButton();
                sliderButtonZ.showSliderButton();
                button.m_93666_(RangeSliderButton.EDIT_TEXT);
            }
        }));
        int resetButtonLeftPosition = sliderButtonZ.f_93620_ + sliderButtonZ.m_5711_();
        this.m_142416_((GuiEventListener)new TextButton(resetButtonLeftPosition, top, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            sliderButtonX.reset();
            sliderButtonY.reset();
            sliderButtonZ.reset();
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPart, new CustomPosition(0.0f, 0.0f, 0.0f));
        }));
        return sliderButtonX;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int poseButtonWidth = 80;
        this.defaultPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, poseButtonWidth - 10, "default", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_POSE)));
        this.advancedPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos + this.defaultPoseButton.m_5711_(), this.buttonTopPos, poseButtonWidth + 10, "advanced", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_POSE)));
        this.customPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.advancedPoseButton.f_93620_ + this.advancedPoseButton.m_5711_(), this.buttonTopPos, poseButtonWidth + 20, "custom", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_POSE)));
    }
}

