/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;

public class DefaultPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    public static final int BUTTON_WIDTH = 100;
    protected Button crouchingPoseButton;
    protected Button dyingPoseButton;
    protected Button fallFlyingPoseButton;
    protected Button longJumpPoseButton;
    protected Button sleepingPoseButton;
    protected Button spinAttackPoseButton;
    protected Button standingPoseButton;
    protected Button swimmingPoseButton;

    public DefaultPoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void checkPoseButtonState(Pose pose, ModelPose modelPose) {
        Pose currentPose = pose != null ? pose : this.getEasyNPCEntity().m_20089_();
        boolean isCustomModelPose = (modelPose != null ? modelPose : this.modelData.getModelPose()) == ModelPose.CUSTOM;
        this.standingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.STANDING;
        this.crouchingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.CROUCHING;
        this.dyingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.DYING;
        this.fallFlyingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.FALL_FLYING;
        this.longJumpPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.LONG_JUMPING;
        this.sleepingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SLEEPING;
        this.spinAttackPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SPIN_ATTACK;
        this.swimmingPoseButton.f_93623_ = isCustomModelPose || currentPose != Pose.SWIMMING;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultPoseButton.f_93623_ = false;
        int poseButtonLeft = this.contentLeftPos + 175;
        this.standingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos, 100, "pose.standing", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.STANDING);
            this.checkPoseButtonState(Pose.STANDING, ModelPose.DEFAULT);
        }));
        this.crouchingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 24, 100, "pose.crouching", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.CROUCHING);
            this.checkPoseButtonState(Pose.CROUCHING, ModelPose.DEFAULT);
        }));
        this.dyingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 48, 100, "pose.dying", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.DYING);
            this.checkPoseButtonState(Pose.DYING, ModelPose.DEFAULT);
        }));
        this.fallFlyingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 72, 100, "pose.fall_flying", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.FALL_FLYING);
            this.checkPoseButtonState(Pose.FALL_FLYING, ModelPose.DEFAULT);
        }));
        this.longJumpPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 96, 100, "pose.long_jumping", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.LONG_JUMPING);
            this.checkPoseButtonState(Pose.LONG_JUMPING, ModelPose.DEFAULT);
        }));
        this.sleepingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 120, 100, "pose.sleeping", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.SLEEPING);
            this.checkPoseButtonState(Pose.SLEEPING, ModelPose.DEFAULT);
        }));
        this.spinAttackPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 144, 100, "pose.spin_attack", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.SPIN_ATTACK);
            this.checkPoseButtonState(Pose.SPIN_ATTACK, ModelPose.DEFAULT);
        }));
        this.swimmingPoseButton = (Button)this.m_142416_((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 168, 100, "pose.swimming", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.SWIMMING);
            this.checkPoseButtonState(Pose.SWIMMING, ModelPose.DEFAULT);
        }));
        this.checkPoseButtonState(this.getEasyNPCEntity().m_20089_(), this.modelData.getModelPose());
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        boolean entityInvisible = this.getEasyNPCEntity().m_20145_();
        this.getEasyNPCEntity().m_6842_(false);
        ScreenHelper.renderScaledEntityAvatar(this.contentLeftPos + 80, this.contentTopPos + 145, 36, (float)(this.contentLeftPos + 80) - this.xMouse, (float)(this.contentTopPos + 85) - this.yMouse, this.getEasyNPC(), this.getEasyNPC().getEasyNPCScaleData(), this.getEasyNPC().getEasyNPCModelData());
        this.getEasyNPCEntity().m_6842_(entityInvisible);
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTicks, mouseX, mouseY);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.contentTopPos, (int)(this.contentLeftPos + 169), (int)(this.contentTopPos + 207), (int)-16777216);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 1), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 206), (int)-5592406);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 145), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 206), (int)-1433892728);
        DefaultPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 145), (int)(this.contentLeftPos + 168), (int)(this.contentTopPos + 150), (int)-1433892728);
    }
}

