/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class AdvancedPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    protected RangeSliderButton headRotationSliderButton;
    protected RangeSliderButton bodyRotationSliderButton;
    protected RangeSliderButton armsRotationSliderButton;
    protected RangeSliderButton leftArmRotationSliderButton;
    protected RangeSliderButton rightArmRotationSliderButton;
    protected RangeSliderButton leftLegRotationSliderButton;
    protected RangeSliderButton rightLegRotationSliderButton;

    public AdvancedPoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private RangeSliderButton createVisibilityRotationSlider(int left, int top, ModelPart modelPart, String label) {
        RangeSliderButton sliderRotationButtonX = this.createRotationSlider(left, top, modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.m_142416_((GuiEventListener)new Checkbox(sliderRotationButtonX.f_93620_ + 3, top - sliderRotationButtonX.m_93694_(), "", modelPartVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.advancedPoseButton.f_93623_ = false;
        int sliderLeftDefaultPos = this.contentLeftPos - 3;
        int sliderTopPos = this.contentTopPos + 56;
        int sliderLeftPos = sliderLeftDefaultPos;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 60;
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodyRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.armsRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = sliderLeftDefaultPos;
            this.rightArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        sliderLeftPos = sliderLeftDefaultPos;
        if (this.modelData.hasRightLegModelPart()) {
            this.rightLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegRotationSliderButton = this.createVisibilityRotationSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(this.contentLeftPos + 157, this.contentTopPos + 165, 50, (float)(this.contentLeftPos + 150) - this.xMouse, (float)(this.contentTopPos + 80) - this.yMouse, this.getEasyNPC());
        if (this.modelData.hasHeadModelPart() && this.headRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.head", this.headRotationSliderButton.f_93620_ + 20, this.headRotationSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodyRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.body", this.bodyRotationSliderButton.f_93620_ + 20, this.bodyRotationSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.left_arm", this.leftArmRotationSliderButton.f_93620_ + 20, this.leftArmRotationSliderButton.f_93621_ - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.arms", this.armsRotationSliderButton.f_93620_ + 20, this.armsRotationSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.right_arm", this.rightArmRotationSliderButton.f_93620_ + 20, this.rightArmRotationSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.left_leg", this.leftLegRotationSliderButton.f_93620_ + 20, this.leftLegRotationSliderButton.f_93621_ - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegRotationSliderButton != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "pose.right_leg", this.rightLegRotationSliderButton.f_93620_ + 20, this.rightLegRotationSliderButton.f_93621_ - 12);
        }
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTicks, mouseX, mouseY);
        int backgroundTopPos = this.contentTopPos + 30;
        AdvancedPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 109), (int)backgroundTopPos, (int)(this.contentLeftPos + 206), (int)(backgroundTopPos + 178), (int)-16777216);
        AdvancedPoseConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 110), (int)(backgroundTopPos + 1), (int)(this.contentLeftPos + 205), (int)(backgroundTopPos + 177), (int)-5592406);
    }
}

