/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ObjectiveConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static final int SPACE_BETWEEN_ENTRIES = 20;
    protected final ObjectiveDataSet objectiveDataSet = this.getObjectiveDataSet();
    protected Button basicObjectiveButton;
    protected Button followObjectiveButton;
    protected Button attackObjectiveButton;
    protected Button lookObjectiveButton;

    public ObjectiveConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected Checkbox getObjectiveCheckbox(int left, int top, ObjectiveType objectiveType) {
        return this.getObjectiveCheckbox(left, top, objectiveType, 0.6);
    }

    protected Checkbox getObjectiveCheckbox(int left, int top, ObjectiveType objectiveType, double speedModifier) {
        return new Checkbox(left, top, objectiveType.getObjectiveName(), this.objectiveDataSet.hasObjective(objectiveType), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = this.objectiveDataSet.getOrCreateObjective(objectiveType);
            objectiveDataEntry.setSpeedModifier(speedModifier);
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        });
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.basicObjectiveButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, 60, "basic", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.BASIC_OBJECTIVE)));
        this.followObjectiveButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.basicObjectiveButton.f_93620_ + this.basicObjectiveButton.m_5711_(), this.buttonTopPos, 60, "follow", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.FOLLOW_OBJECTIVE)));
        this.attackObjectiveButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.followObjectiveButton.f_93620_ + this.followObjectiveButton.m_5711_(), this.buttonTopPos, 60, "attack", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ATTACK_OBJECTIVE)));
        this.lookObjectiveButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.attackObjectiveButton.f_93620_ + this.attackObjectiveButton.m_5711_(), this.buttonTopPos, 65, "look", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.LOOK_OBJECTIVE)));
    }
}

